package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;


/**
 * グループ取得用のパラメータです。
 * @author Youngmin Chae
 * @version 1.0.0
 */
public class EnqueteReplyParameters extends HttpParameterObject {
	private final String enqueteParam;
	
	/**
	 * {@link EnqueteReplyParameters} のインスタンスを初期化します。
	 * @param enqueteParam ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public EnqueteReplyParameters(String enqueteParam) {
		this.enqueteParam = enqueteParam;
	}
	
	public String getEnqueteParam() {
		return enqueteParam;
	}
	
}
