package jp.agentec.abook.abv.bl.dto;


/**
 * ジャンル情報を格納します。
 * 1.0.1ジャンル階層化
 * @author Taejin Hong
 * @version　1.0.1
 */
public class CategoryDto extends AbstractDto {
	public int categoryRelationId; // comment out??
	public int categoryId;
	public int parentCategoryId;
	public String categoryName;
	public int contentCount = 0;
	public String displayCount;
	public short dispOrder;
	public String categoryPath;
	//1.8.1からジャンル改善仕様追加
	public int categoryLevel;

	public CategoryDto() {
	}

	public CategoryDto(int categoryId, String categoryName, short dispOrder, int parentCategoryId) {
		this.categoryId = categoryId;
		this.categoryName = categoryName;
		this.dispOrder = dispOrder;
		this.parentCategoryId = parentCategoryId;
	}

	@Override
	public Object[] getInsertValues() {
		return new Object[]{categoryRelationId, categoryId, parentCategoryId, categoryName, contentCount, displayCount, dispOrder};
	}

	@Override
	public String[] getKeyValues() {
		return new String[]{""+ categoryId, ""+ parentCategoryId};
	}
}
