package jp.agentec.abook.abv.bl.dto;


/**
 * タグ情報を格納します。
 * @author Taejin Hong
 * @version　1.0.0
 */
public class ContentTagDto extends AbstractDto {
	public long contentId;
	public String tagName;
	
	@Override
	public Object[] getInsertValues() {
		return new Object[]{contentId, tagName};
	}

	@Override
	public String[] getKeyValues() {
		//	実際のPKはcontent_idとtag_nameの組み合わせだが、このテーブルの場合、コンテンツ単位の更新が行われる為、content_idのみPKとして返す。
		return new String[]{""+ contentId};
	}

}
