package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.os.AsyncTask;

import com.theta.helper.ThetaHelper;
import com.theta.network.HttpConnector;
import com.theta.network.ThetaDeviceInfo;

import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.ui.viewer.activity.DeviceImageListActivity;

/**
 * THETAカメラ情報を取得するスレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class DeviceInfoTask extends AsyncTask<Void, String, ThetaDeviceInfo> {
    private static final String TAG = "DeviceInfoTask";
    private final WeakReference<DeviceImageListActivity> refActivity;
    private static final int FAIL_RETRAY_DELAY_MILLIS = 2000;

    public DeviceInfoTask(DeviceImageListActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected ThetaDeviceInfo doInBackground(Void... params) {
        Logger.d(TAG, "doInBackground");
        HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS);
        final int MAX_RETRY_COUNT = 6;
        ThetaDeviceInfo deviceInfo = null;
        //Wifi切り替え時間が必要なので、失敗した場合、5回リトライする。
        for (int retryCount = 0; retryCount < MAX_RETRY_COUNT; retryCount++) {
            deviceInfo = camera.getDeviceInfo();
            if (deviceInfo.getModel() == null || deviceInfo.getModel().length() == 0) {
                try {
                    Thread.sleep(FAIL_RETRAY_DELAY_MILLIS);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (retryCount == 0) { //失敗時、LTE環境の影響のため、アプリで利用するネットワークを設定
                    ThetaHelper helper = new ThetaHelper(refActivity.get());
                    helper.appConnectedWifiOnly();
                }

            } else {
                retryCount = MAX_RETRY_COUNT;
            }
        }
        return deviceInfo;
    }

    @Override
    protected void onPostExecute(ThetaDeviceInfo deviceInfo) {
        Logger.d(TAG, "onPostExecute");
        DeviceImageListActivity activity = refActivity.get();
        activity.thetaDeviceInfoTaskFinish(deviceInfo);
    }
}
