package jp.agentec.abook.abv.ui.viewer.adapter;

import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ABVPDFIndexAdapter extends BaseAdapter {
	private static final String TAG = "ABVPDFIndexAdapter";

//	private Context context;
	private LayoutInflater inflater;
	private List<ContentPDFIndexDto> listItem;
	private AlertDialog dialog;
	PDFIndexDialog pdfalert;

	public ABVPDFIndexAdapter(Context context, List<ContentPDFIndexDto> listItem, AlertDialog dialog, PDFIndexDialog pdfalert) {
//		this.context = context;
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.listItem = listItem;
		this.dialog = dialog;
		this.pdfalert = pdfalert;
	}

	@Override
	public int getCount() {
		return listItem.size();
	}

	@Override
	public ContentPDFIndexDto getItem(int position) {
		return listItem.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(final int position, View convertView, ViewGroup parent) {
		if (null == convertView) {
			convertView = inflater.inflate(R.layout.item_pdfindex_render, null);
		}
		
		//setStripeColor(context, convertView, position);

		final ContentPDFIndexDto dto = listItem.get(position);

		Logger.v(TAG, "getView:1");

		TextView pageText = (TextView) convertView.findViewById(R.id.pdfindex_text_page);
		pageText.setText(dto.getTitle());

		ImageView image = (ImageView) convertView.findViewById(R.id.pdfindex_img_move);
		image.setFocusable(false);
		image.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				dialog.dismiss();
				pdfalert.pushRid(dto.getParentID());
				pdfalert.showDialog(dto.getId());
			}
		});

		if (!dto.isParent()) {
			image.setVisibility(View.INVISIBLE);
		}

		return convertView;
	}
}
