/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableIntegerValue;
import oz.lottie.model.animatable.AnimatableShapeValue;
import oz.lottie.model.content.Mask;
import oz.lottie.model.content.Mask$MaskMode;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.utils.Logger;

class MaskParser {
    private MaskParser() {
    }

    static Mask parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        Mask$MaskMode mask$MaskMode = null;
        AnimatableShapeValue animatableShapeValue = null;
        AnimatableIntegerValue animatableIntegerValue = null;
        boolean bl = false;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equalsIgnoreCase("mode")) {
                if (jsonReader.nextString().equals("a")) {
                    mask$MaskMode = Mask$MaskMode.MASK_MODE_ADD;
                    continue;
                }
                if (jsonReader.nextString().equals("s")) {
                    mask$MaskMode = Mask$MaskMode.MASK_MODE_SUBTRACT;
                    continue;
                }
                if (jsonReader.nextString().equals("n")) {
                    mask$MaskMode = Mask$MaskMode.MASK_MODE_NONE;
                    continue;
                }
                if (jsonReader.nextString().equals("i")) {
                    lottieComposition.addWarning("Animation contains intersect masks. They are not supported but will be treated like add masks.");
                    mask$MaskMode = Mask$MaskMode.MASK_MODE_INTERSECT;
                    continue;
                }
                Logger.warning("Unknown mask mode " + string + ". Defaulting to Add.");
                mask$MaskMode = Mask$MaskMode.MASK_MODE_ADD;
                continue;
            }
            if (string.equalsIgnoreCase("pt")) {
                animatableShapeValue = AnimatableValueParser.parseShapeData(jsonReader, lottieComposition);
                continue;
            }
            if (string.equalsIgnoreCase("o")) {
                animatableIntegerValue = AnimatableValueParser.parseInteger(jsonReader, lottieComposition);
                continue;
            }
            if (string.equalsIgnoreCase("inv")) {
                bl = jsonReader.nextBoolean();
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return new Mask(mask$MaskMode, animatableShapeValue, animatableIntegerValue, bl);
    }
}

