/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.maxicode.decoder;

import java.util.Map;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonDecoder;
import oz.util.barcode.common.reedsolomon.ReedSolomonException;
import oz.util.barcode.maxicode.decoder.BitMatrixParser;
import oz.util.barcode.maxicode.decoder.DecodedBitStreamParser;

public final class Decoder {
    private static final int ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.MAXICODE_FIELD_64);

    public DecoderResult decode(BitMatrix bitMatrix) {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map map) {
        byte[] byArray;
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        byte[] byArray2 = bitMatrixParser.readCodewords();
        this.correctErrors(byArray2, 0, 10, 10, 0);
        int n = byArray2[0] & 0xF;
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                this.correctErrors(byArray2, 20, 84, 40, 1);
                this.correctErrors(byArray2, 20, 84, 40, 2);
                byArray = new byte[94];
                break;
            }
            case 5: {
                this.correctErrors(byArray2, 20, 68, 56, 1);
                this.correctErrors(byArray2, 20, 68, 56, 2);
                byArray = new byte[78];
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        System.arraycopy(byArray2, 0, byArray, 0, 10);
        System.arraycopy(byArray2, 20, byArray, 10, byArray.length - 10);
        return DecodedBitStreamParser.decode(byArray, n);
    }

    private void correctErrors(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        int n6 = n4 == 0 ? 1 : 2;
        int[] nArray = new int[n5 / n6];
        int n7 = 0;
        while (n7 < n5) {
            if (n4 == 0 || n7 % 2 == n4 - 1) {
                nArray[n7 / n6] = byArray[n7 + n] & 0xFF;
            }
            ++n7;
        }
        try {
            this.rsDecoder.decode(nArray, n3 / n6);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        n7 = 0;
        while (n7 < n2) {
            if (n4 == 0 || n7 % 2 == n4 - 1) {
                byArray[n7 + n] = (byte)nArray[n7 / n6];
            }
            ++n7;
        }
    }
}

