/*
 * Decompiled with CFR 0.152.
 */
package oz.util.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import oz.util.drawable.FitBitmapDrawable$MyConstantState;

public class FitBitmapDrawable
extends Drawable {
    private Bitmap mBitmap;
    private Paint mPaint;
    private float mScale;

    public FitBitmapDrawable(Bitmap bitmap, float f2) {
        this.init(bitmap, f2);
        this.mPaint = new Paint(3);
    }

    private FitBitmapDrawable(Bitmap bitmap, float f2, Paint paint) {
        this.init(bitmap, f2);
        this.mPaint = new Paint(paint);
    }

    private void init(Bitmap bitmap, float f2) {
        this.mBitmap = bitmap;
        this.mScale = f2;
    }

    public void draw(Canvas canvas) {
        if (this.mBitmap != null) {
            Rect rect = this.getBounds();
            int n = rect.width();
            int n2 = rect.height();
            if (n != 0 && n2 != 0) {
                float f2;
                int n3 = this.mBitmap.getWidth();
                int n4 = this.mBitmap.getHeight();
                RectF rectF = new RectF(rect);
                float f3 = 1.0f;
                if (this.mScale > 0.0f && this.mScale != 1.0f) {
                    f3 = this.mScale;
                    rectF.inset(((float)n - (float)n * f3) / 2.0f, ((float)n2 - (float)n2 * f3) / 2.0f);
                }
                Rect rect2 = new Rect();
                float f4 = rectF.width() / (float)n3;
                float f5 = Math.min(f4, f2 = rectF.height() / (float)n4);
                float f6 = f5 < 1.0f ? 1.0f / f5 : f5;
                float f7 = 1.0f / f6;
                rectF.left *= f6;
                rectF.top *= f6;
                rectF.right *= f6;
                rectF.bottom *= f6;
                Gravity.apply((int)17, (int)n3, (int)n4, (Rect)new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom)), (Rect)rect2);
                canvas.save();
                canvas.scale(f7, f7);
                canvas.drawBitmap(this.mBitmap, new Rect(0, 0, n3, n4), rect2, this.mPaint);
                canvas.restore();
            }
        }
    }

    public void setAlpha(int n) {
        this.mPaint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public Drawable.ConstantState getConstantState() {
        return new FitBitmapDrawable$MyConstantState(this, null);
    }

    public FitBitmapDrawable cloneMe() {
        return new FitBitmapDrawable(this.mBitmap, this.mScale, this.mPaint);
    }
}

