package jp.agentec.abook.abv.bl.data;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.tables.LContentObjectLog;
import jp.agentec.abook.abv.bl.data.tables.LContentPageReadingLog;
import jp.agentec.abook.abv.bl.data.tables.LContentReadingLog;
import jp.agentec.abook.abv.bl.data.tables.MAcms;
import jp.agentec.abook.abv.bl.data.tables.MAppConfig;
import jp.agentec.abook.abv.bl.data.tables.MCategory;
import jp.agentec.abook.abv.bl.data.tables.MChatGroup;
import jp.agentec.abook.abv.bl.data.tables.MGroup;
import jp.agentec.abook.abv.bl.data.tables.MMemberInfo;
import jp.agentec.abook.abv.bl.data.tables.MOperationGroupMaster;
import jp.agentec.abook.abv.bl.data.tables.MPasswordLockInfo;
import jp.agentec.abook.abv.bl.data.tables.MServiceOption;
import jp.agentec.abook.abv.bl.data.tables.MShopMember;
import jp.agentec.abook.abv.bl.data.tables.MWorkerGroup;
import jp.agentec.abook.abv.bl.data.tables.RChatRoomShopMember;
import jp.agentec.abook.abv.bl.data.tables.RCollaborationMember;
import jp.agentec.abook.abv.bl.data.tables.RContentCategory;
import jp.agentec.abook.abv.bl.data.tables.RContentGroup;
import jp.agentec.abook.abv.bl.data.tables.ROperationContent;
import jp.agentec.abook.abv.bl.data.tables.ROperationGroupMasterOperation;
import jp.agentec.abook.abv.bl.data.tables.RShopMemberGroup;
import jp.agentec.abook.abv.bl.data.tables.RTaskWorkerGroup;
import jp.agentec.abook.abv.bl.data.tables.SQLiteTableScript;
import jp.agentec.abook.abv.bl.data.tables.TArchive;
import jp.agentec.abook.abv.bl.data.tables.TChatMessage;
import jp.agentec.abook.abv.bl.data.tables.TChatRoom;
import jp.agentec.abook.abv.bl.data.tables.TCollaboration;
import jp.agentec.abook.abv.bl.data.tables.TCollaborationDetail;
import jp.agentec.abook.abv.bl.data.tables.TContent;
import jp.agentec.abook.abv.bl.data.tables.TContentBookmark;
import jp.agentec.abook.abv.bl.data.tables.TContentDownloadQueue;
import jp.agentec.abook.abv.bl.data.tables.TContentMarking;
import jp.agentec.abook.abv.bl.data.tables.TContentMemo;
import jp.agentec.abook.abv.bl.data.tables.TContentOldPdf;
import jp.agentec.abook.abv.bl.data.tables.TContentPage;
import jp.agentec.abook.abv.bl.data.tables.TContentResource;
import jp.agentec.abook.abv.bl.data.tables.TContentServerSearched;
import jp.agentec.abook.abv.bl.data.tables.TContentTag;
import jp.agentec.abook.abv.bl.data.tables.TEnquete;
import jp.agentec.abook.abv.bl.data.tables.TMarkingSetting;
import jp.agentec.abook.abv.bl.data.tables.TOperation;
import jp.agentec.abook.abv.bl.data.tables.TPushMessage;
import jp.agentec.abook.abv.bl.data.tables.TTask;
import jp.agentec.abook.abv.bl.data.tables.TTaskReport;
import jp.agentec.abook.abv.bl.data.tables.TTaskReportApproval;
import jp.agentec.abook.abv.bl.data.tables.TTaskReportItems;
import jp.agentec.abook.abv.bl.data.tables.TTaskReportSend;
import jp.agentec.adf.util.StringUtil;

public class CommunicationDataOpenHelper {
	private Throwable lastError = null;
	private boolean createFailed = false;
	private static final String TAG = "DATA";
	
	public Throwable getLastError() {
		return lastError;
	}
	
	public boolean isCreated() {
		return !createFailed;
	}

	private List<SQLiteTableScript> getTableScripts() {
		List<SQLiteTableScript> iTableScripts = new ArrayList<SQLiteTableScript>();

		//ABCOMM関連テーブル
		iTableScripts.add(new MChatGroup());
		iTableScripts.add(new MShopMember());
		iTableScripts.add(new TChatRoom());
		iTableScripts.add(new TChatMessage());
		iTableScripts.add(new TCollaboration());
		iTableScripts.add(new TCollaborationDetail());
		iTableScripts.add(new TArchive());
		iTableScripts.add(new RShopMemberGroup());
		iTableScripts.add(new RChatRoomShopMember());
		iTableScripts.add(new RCollaborationMember());

		return iTableScripts; 
	}


	public void onCreate(SQLiteDatabase db) {
		Logger.i(TAG, "create database version " + db.getVersion());
		List<SQLiteTableScript> iTableScripts = getTableScripts();
		
		try {
			List<String> ddl;
			
			db.beginTransaction();
			
			for (SQLiteTableScript iTableScript : iTableScripts) {
				ddl = iTableScript.getCreateScript(db.getVersion());
				for (String sql : ddl) {
					if (!StringUtil.isNullOrWhiteSpace(sql)) {
						Logger.d(TAG, sql);
						db.execSQL(sql);
					}
				}
			}
			
			db.setTransactionSuccessful();	//	commit
			createFailed = false;
		} catch (Exception e) {
			lastError = e;
			createFailed = true;
		} finally {
			db.endTransaction();
		}
	}

	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		Logger.i(TAG, String.format("upgrade database to version %d from version : %d", newVersion, oldVersion));
		List<SQLiteTableScript> iTableScripts = getTableScripts();
		
		try {
			List<String> ddl;
			List<String> dml;
			
			db.beginTransaction();
			
			for (SQLiteTableScript iTableScript : iTableScripts) {
				ddl = iTableScript.getUpgradeScript(oldVersion, newVersion);
				
				if (ddl != null) {
					for (String sql : ddl) {
						if (!StringUtil.isNullOrWhiteSpace(sql)) {
							Logger.d(TAG, sql);
							db.execSQL(sql);
						}
					}
				}

				dml = iTableScript.getMigrationScript(db, oldVersion, newVersion, null);
				if (dml != null) {
					for (String sql : dml) {
						if (!StringUtil.isNullOrWhiteSpace(sql)) {
							Logger.d(TAG, sql);
							db.execSQL(sql);
						}
					}
				}
			}
			
			db.setTransactionSuccessful();	//	commit
			createFailed = false;
		} catch (Exception e) {
			Logger.e(TAG, e);
			lastError = e;
			createFailed = true;
		} finally {
			db.endTransaction();
		}
	}
}
