package jp.agentec.abook.abv.bl.data.dao;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.dto.MemberInfoDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.adf.util.CollectionUtil;
import jp.agentec.adf.util.StringUtil;

public class ChatRoomDao extends AbstractCommunicationDao {

	/**
	 * {@link ChatRoomDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ChatRoomDao() {
	}

	@Override
	protected ChatRoomDto convert(Cursor cursor) {
		ChatRoomDto dto = new ChatRoomDto();

		int column = cursor.getColumnIndex("chat_room_id");
		if (column != -1) {
			dto.chatRoomId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("chat_room_name");
		if (column != -1) {
			dto.chatRoomName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("type");
		if (column != -1) {
			dto.type = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("unread_count");
		if (column != -1) {
			dto.unreadCount = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("user_count");
		if (column != -1) {
			dto.userCount = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("view_flg");
		if (column != -1) {
			dto.viewFlg = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("favorite_register_date");
		if (column != -1) {
			dto.favoriteRegisterDate = cursor.getString(column);
		}
		column = cursor.getColumnIndex("message");
		if (column != -1) {
			dto.message = cursor.getString(column);
		}
		column = cursor.getColumnIndex("message_type");
		if (column != -1) {
			dto.messageType = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("insert_date");
		if (column != -1) {
			dto.insertDate = cursor.getString(column);
		}
		return dto;
	}

	public List<ChatRoomDto> getAllChatRoom(Integer roomType) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append("      cr.chat_room_id ");
		sql.append("      ,cr.chat_room_name ");
		sql.append("      ,cr.type ");
		sql.append("      ,coalesce (cr.favorite_register_date,'') favorite_register_date");
		sql.append("      ,coalesce (cr.unread_count,0) unread_count");
		sql.append("      ,coalesce (cm.message,'') message");
		sql.append("      ,coalesce (cm.message_type,0) message_type");
		sql.append("      ,coalesce (cm.insert_date,'') insert_date");
		sql.append("      ,coalesce (cr.user_count,0) user_count ");
		sql.append(" FROM ");
		sql.append("      t_chat_room AS cr ");
		sql.append(" LEFT JOIN ");
		sql.append("      ( SELECT max(insert_date) insert_date, message, message_type, chat_room_id FROM t_chat_message GROUP BY chat_room_id ) AS cm ");
		sql.append("   ON cr.chat_room_id = cm.chat_room_id ");
		sql.append(" WHERE cr.type =? ");
		sql.append(" AND (cr.view_flg IS null OR cr.view_flg != 1 )");
		sql.append(" GROUP BY cr.chat_room_id ");
		sql.append(" ORDER BY CASE WHEN unread_count = 0 THEN 0 ELSE 1 END DESC, cm.insert_date DESC ");
		List<ChatRoomDto> list = rawQueryGetDtoList(sql.toString(), new String[]{""+ roomType}, ChatRoomDto.class);
		return list;
	}

	public ChatRoomDto getChatRoom(Integer roomId) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append("      cr.chat_room_id ");
		sql.append("      ,cr.chat_room_name ");
		sql.append("      ,cr.type ");
		sql.append(" FROM ");
		sql.append("      t_chat_room AS cr ");
		sql.append(" WHERE cr.chat_room_id =? ");
		ChatRoomDto list = rawQueryGetDto(sql.toString(), new String[]{""+ roomId}, ChatRoomDto.class);
		return list;
	}

	public List<ChatRoomDto> getAllChatRoombyKeyword(String[] keywords) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append("      cr.chat_room_id ");
		sql.append("      ,cr.chat_room_name ");
		sql.append("      ,cr.type ");
		sql.append("      ,coalesce (cr.favorite_register_date,'') favorite_register_date");
		sql.append("      ,coalesce (cr.unread_count,0) unread_count");
		sql.append("      ,coalesce (cm.message,'') message");
		sql.append("      ,coalesce (cm.message_type,0) message_type");
		sql.append("      ,coalesce (cm.insert_date,'') insert_date");
		sql.append("      ,coalesce (cr.user_count,0) user_count ");
		sql.append(" FROM ");
		sql.append("      t_chat_room AS cr ");
		sql.append(" LEFT JOIN ");
		sql.append("      ( SELECT max(insert_date) insert_date, message, message_type, chat_room_id FROM t_chat_message GROUP BY chat_room_id ) AS cm ");
		sql.append("   ON cr.chat_room_id = cm.chat_room_id ");
		sql.append("  LEFT JOIN r_chat_room_shop_member rcrsm ");
		sql.append("   ON cr.chat_room_id = rcrsm.chat_room_id ");
		sql.append("  INNER JOIN m_shop_member sm ");
		sql.append("   ON rcrsm.shop_member_id = sm.shop_member_id ");
		sql.append(" WHERE ");
		List<String> whereSqlList = new ArrayList<String>();
		for (String keyword : keywords) {
			String whereSql = "( cr.chat_room_name LIKE  '%" + keyword + "%' )";
			whereSqlList.add(whereSql);
		}
		String whereSql = StringUtil.join(" AND ", whereSqlList);
		sql.append(whereSql);
		sql.append(" AND (cr.view_flg IS null OR cr.view_flg != 1 )");
		sql.append(" GROUP BY cr.chat_room_id ");
		sql.append(" ORDER BY CASE WHEN unread_count = 0 THEN 0 ELSE 1 END DESC, cm.insert_date DESC ");
		List<ChatRoomDto> list = rawQueryGetDtoList(sql.toString(), null, ChatRoomDto.class);
		return list;
	}

	public ChatRoomDto getFavoriteChatRoom() {
		return rawQueryGetDto("select * from t_chat_room where favorite_register_date is NOT NULL", null, ChatRoomDto.class);
	}

	public ChatRoomDto getNotFavoriteChatRoom() {
		return rawQueryGetDto("select * from t_chat_room where favorite_register_date is NULL", null, ChatRoomDto.class);
	}

	public void insertChatRoom(ChatRoomDto dto) {
		Integer chatRoomId = dto.chatRoomId;
		if (dto.unreadCount == 0) {
			insert("insert or replace into t_chat_room (chat_room_id, chat_room_name, type, unread_count, user_count, favorite_register_date, view_flg) values (?,?,?,?,?,?, (select view_flg from t_chat_room where chat_room_id =" + chatRoomId + "))", dto.getInsertValues());
		} else {
			insert("insert or replace into t_chat_room (chat_room_id, chat_room_name, type, unread_count, user_count, favorite_register_date, view_flg) values (?,?,?,?,?,?,0)", dto.getInsertValues());
		}
	}

	public void updateChatRoomName(String roomName, Integer roomId) {
		update("update t_chat_room set chat_room_name = ? where chat_room_id = ?", new Object[]{roomName, roomId});
	}

	public void changeRoomViewFlg(Integer roomId, Integer viewFlg) {
		update("update t_chat_room set view_flg = ? where chat_room_id = ?", new Object[]{viewFlg, roomId});
	}

	public void insertChatRoom(List<ChatRoomDto> chatRoomDtoList) {
		try {
			beginTransaction();
			ArrayList<Integer> roomIdList = new ArrayList<Integer>();
			for (ChatRoomDto chatRoomDto : chatRoomDtoList) {
				roomIdList.add(chatRoomDto.chatRoomId);
				insertChatRoom(chatRoomDto);
				deleteChatRoomUsers(chatRoomDto.chatRoomId);
				insertChatRoomUsers(chatRoomDto.attendUsers, chatRoomDto.chatRoomId);
			}
			update("delete from t_chat_room where chat_room_id NOT IN (" + StringUtil.join(" , ", roomIdList) + ")", null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("insertChatRoomList failed.", e);
			throw new RuntimeException(e);
		}
	}

	public void insertChatRoomUsers(List<Integer> attendUsers, Integer chatRoomId) {
		if (CollectionUtil.isEmpty(attendUsers)) {
			return;
		}
		String sql = "insert or replace into r_chat_room_shop_member (chat_room_id, shop_member_id) values ";
		ArrayList<String> insertAttendUser = new ArrayList<String>();
		for (Integer attendUserId : attendUsers) {
			insertAttendUser.add("(" + chatRoomId + ", " +  attendUserId + ")");
		}
		insert(sql + StringUtil.join(", ", insertAttendUser), new Object[] {});
	}

	public void deleteChatRoomUsers(Integer chatRoomId) {
		update("delete from r_chat_room_shop_member where chat_room_id = ?", new Integer[]{chatRoomId});
	}

	public boolean updateChatRoom(ChatRoomDto dto) {
		long count = update("update t_chat_room set chat_room_name=?, type=?, unread_count=?, user_count=?, favorite_register_date=? where chat_room_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void deleteChatRoom() {
		try {
			beginTransaction();
			delete("r_chat_room_shop_member", null, null);
			delete("t_chat_room", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteChatRoom failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}

}
