package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class MMemberInfo extends SQLiteTableScript {

	public MMemberInfo() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		//	1.5.0 -> contract_id 削除
		sql.append(" CREATE TABLE m_member_info ( ");
		sql.append("        login_id VARCHAR(64) NOT NULL ");
		sql.append("      , password BLOB NOT NULL ");
		sql.append("      , member_name VARCHAR(64) ");
		sql.append("      , sid VARCHAR(64) ");
		//sql.append("      , contract_id INTEGER ");	//	1.5.0から削除
		sql.append("      , login_status INTEGER ");
		sql.append("      , invalid_password_count SMALLINT DEFAULT 0 ");
		sql.append("      , last_login_date DATETIME ");
		sql.append("      , last_change_password_date DATETIME ");
		sql.append("      , last_cms_access_date DATETIME ");
		sql.append("      , password_expiry_date DATETIME ");
		sql.append("      , user_id INTEGER");
		sql.append("      , last_update_infor VARCHAR(64)");
		sql.append("      , worker_code TEXT");
		sql.append("      , PRIMARY KEY (login_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
