package jp.agentec.adf.net.http;


public class HttpDownloadSimpleNotification {
	protected HttpDownloadState downloadState;
	protected Exception error;
	/**
	 * その他、必要な情報を設定します。この値は任意です。
	 * @since 1.0.0
	 */
	protected Object customInformation;
	
	public HttpDownloadSimpleNotification() {
	}
	
	public HttpDownloadSimpleNotification(HttpDownloadState downloadState, Object customInformation) {
		this.downloadState = downloadState;
		this.error = null;
		this.customInformation = customInformation;
	}
	
	public HttpDownloadState getDownloadState() {
		return downloadState;
	}
	public Exception getError() {
		return error;
	}
	public Object getCustomInformation() {
		return customInformation;
	}
	
	public void setDownloadState(HttpDownloadState downloadState) {
		this.downloadState = downloadState;
	}
	public void setError(Exception error) {
		this.error = error;
	}
	public void setCustomInformation(Object customInformation) {
		this.customInformation = customInformation;
	}
	
	public boolean isDownloading() {
		return downloadState == HttpDownloadState.downloading;
	}
	
	public boolean isPaused() {
		return downloadState == HttpDownloadState.paused;
	}
	
	public boolean isFailed() {
		return downloadState == HttpDownloadState.failed;
	}
}
