package jp.agentec.adf.net.http;

import java.io.File;
import java.net.URLConnection;

import jp.agentec.adf.util.StringUtil;

/**
 * HTTP Post requestのmultipart情報を格納します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class HttpMultipart {
	private String name;
	private String contentType;
	private String contentTextCharset;
	private String parameters;
	private String contentTransferEncoding;
	private File file;
	private boolean fileAttach;
	
	public static final String ContentTypeTextPlain = "text/plain";
	
	public HttpMultipart (String name, String parameters) {
		this.name = name;
		this.contentType = ContentTypeTextPlain;
		this.contentTextCharset = HttpRequestSender.DefaultEncoding;
		this.parameters = parameters;
		this.contentTransferEncoding = null;
		this.file = null;
		
		this.fileAttach = false;
	}
	
	public HttpMultipart (String name, String contentType, String parameters) {
		this.name = name;
		this.contentType = contentType;
		this.contentTextCharset = HttpRequestSender.DefaultEncoding;
		this.parameters = parameters;
		this.contentTransferEncoding = null;
		this.file = null;
		
		this.fileAttach = false;
	}
	
	public HttpMultipart (String name, String contentType, String contentTextCharset, String parameters) {
		this.name = name;
		this.contentType = contentType;
		this.contentTextCharset = contentTextCharset;
		this.parameters = parameters;
		this.contentTransferEncoding = null;
		this.file = null;
		
		this.fileAttach = false;
	}
	
	public HttpMultipart (String name, File file) {
		this.name = name;
		this.contentType = null;
		this.contentTextCharset = null;
		this.parameters = null;
		this.contentTransferEncoding = null;
		this.file = file;
		
		this.fileAttach = (this.file != null && this.file.exists() && this.file.exists());
	}
	
	public HttpMultipart (String name, String contentType, File file) {
		this.name = name;
		this.contentType = contentType;
		this.contentTextCharset = null;
		this.parameters = null;
		this.contentTransferEncoding = null;
		this.file = file;
		
		this.fileAttach = (this.file != null && this.file.exists() && this.file.exists());
	}
	
	public HttpMultipart (String name, String contentType, String contentTransferEncoding, File file) {
		this.name = name;
		this.contentType = contentType;
		this.contentTextCharset = null;
		this.parameters = null;
		this.contentTransferEncoding = contentTransferEncoding;
		this.file = file;
		
		this.fileAttach = (this.file != null && this.file.exists() && this.file.exists());
	}
	
		
	public String getName() {
		return name;
	}
	
	public File getFile() {
		return file;
	}

	public String getContentTextCharset() {
		return contentTextCharset;
	}

	public String getParameters() {
		return parameters;
	}

	public String getContentTransferEncoding() {
		return contentTransferEncoding;
	}

	public String getContentType() {
		return contentType;
	}
	
	public boolean isFileAttach() {
		return fileAttach;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		
		//	Content-Disposition
		sb.append(String.format("%s: form-data; name=\"%s\"", HttpHeaderProperties.PropertyKey.ContentDisposition.key(), name));
					
		if (fileAttach) {
			sb.append(String.format("; filename=\"%s\"", file.getName()));
		}
		
		sb.append(StringUtil.CRLF);
		
		//	Content-Type
		sb.append(String.format("%s: ", HttpHeaderProperties.PropertyKey.ContentType.key()));
		
		if (fileAttach && contentType == null) {
			sb.append(URLConnection.guessContentTypeFromName(file.getName()));
		} else {
			sb.append(contentType);
		}
		
		if (contentTextCharset != null) {
			sb.append(String.format("; charset=%s", contentTextCharset));
		}
		
		sb.append(StringUtil.CRLF);
		
		//	Content-Transfer-Encoding
		if (fileAttach) {
			if (StringUtil.isNullOrEmpty(contentTransferEncoding)) {
				sb.append(String.format("%s: binary", HttpHeaderProperties.PropertyKey.ContentTransferEncoding.key()));
			} else {
				sb.append(String.format("%s: %s", HttpHeaderProperties.PropertyKey.ContentTransferEncoding.key(), contentTransferEncoding));
			}
			
			sb.append(StringUtil.CRLF);
		}
		
		sb.append(StringUtil.CRLF);	//	パートの終わりを示す改行
		
		//	parameter
		if (parameters != null) {
			sb.append(parameters);
		}
        if (file == null) {
            sb.append(StringUtil.CRLF);    //	パートの終わりを示す改行
        }

		return sb.toString();
	}
}
