package jp.agentec.abook.abv.cl.util;

import java.util.Set;

/**
 * Created by jang on 2016/12/06.
 */

public class ThreadUtil {

    private static final String TAG = "ThreadUtil";

    /**
     * 指定のスレッド名のスレッドが動作中であるか確認
     * @param threadName String
     * @return boolean
     */
    public static final boolean isLiveThread(String threadName) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet.toArray(new Thread[threadSet.size()])) {
            if (thread.getName().equals(threadName)) {
                return true;
            }
//            Logger.v(TAG, "[isLiveThread]:threadName=" + thread.getName() + ", target=" + threadName);
        }
        return false;
    }

    public static final boolean isLiveThread(long threadId) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet.toArray(new Thread[threadSet.size()])) {
            if (thread.getId() == threadId) {
                return true;
            }
//            Logger.v(TAG, "[isLiveThread]:threadName=" + thread.getName() + ", target=" + threadName);
        }
        return false;
    }

    public static final void sleep(long time) {
        try {
            Thread.sleep(time);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
