package jp.agentec.abook.abv.ui.viewer.view;

import jp.agentec.abook.abv.bl.acms.client.json.content.PageObjectJSON;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.cl.util.ContentLogUtil;
import jp.agentec.adf.util.FileUtil;

import org.json.adf.JSONObject;

import android.content.Context;
import android.net.Uri;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.ImageView;

public class Action3DImageView extends ImageView implements OnTouchListener {
    private int MOVE_RANGE_X;
    private int MOVE_RANGE_Y;
    private int mCurrentI;
    private int mCurrentJ;
    private int mCurrentIBK;
    private int mCurrentJBK;
    private int mOffsetX;
    private int mOffsetY;
    private boolean mEventFlg = false;
    private int mIndex;
    private int mPage;
    private long mContentId;
    private int maxI;
	private int maxJ;
    private ImageView img3dIcon;
    private String[][] arrayImagePath;
    
    private String mCurrentImagePath;
	private Long mObjectId;
	public int readingLogId;
    
	public Action3DImageView(Context context) {
		super(context);
	}
	public Action3DImageView(Context context, int w, int h, ImageView imgIcon, int index, long contentId, int readingLog, final PageObjectJSON pageObject, String mContentDir) {
		super(context);

		maxI = pageObject.getMediaInfo().getVerticalCount();
		maxJ = pageObject.getMediaInfo().getHorizonCount();

		String imgPath = mContentDir + "/";

		arrayImagePath = new String[maxI][maxJ];
		for (int i = 0; i < maxI; i++) {
			for (int j = 0; j < maxJ; j++) {
				arrayImagePath[i][j] = imgPath + pageObject.getActionInfo().getView3DInfo().getImage(i + 1, j + 1).getFileName();
			}
		}

		this.img3dIcon = imgIcon;

		mIndex = index;
		mPage = pageObject.getPageNumber();
		mObjectId = pageObject.getActionInfo().getObjectId();
		this.readingLogId = readingLog;
		mContentId = contentId;
		mCurrentI = (int) ((float) maxI / 2.0f + 0.5f) - 1;
		mCurrentJ = (int) ((float) maxJ / 2.0f + 0.5f) - 1;
		mCurrentIBK = mCurrentI;
		mCurrentJBK = mCurrentJ;
		MOVE_RANGE_X = (int) ((float) w / ((float) maxJ * 2.0f + 1.5f));
		MOVE_RANGE_Y = (int) ((float) h / ((float) maxI * 2.0f + 1.5f));

		setImageURI(Uri.parse(arrayImagePath[mCurrentI][mCurrentJ]));

		setScaleType(ScaleType.CENTER_INSIDE);
		setAdjustViewBounds(true);

		setOnLongClickListener(new OnLongClickListener() {
			
			@Override
			public boolean onLongClick(View v) {
				v.getParent().requestDisallowInterceptTouchEvent(true);
				if (((ZoomRelativeLayout)v.getParent()).isZooming() == false) {
					setEvent(true, img3dIcon);
					// 開始時のみログとして記録する
					ContentLogUtil.getInstance().insertContentObjectLog(mContentId, readingLogId, pageObject);
				}
				return true;
			}
		});

		setOnTouchListener(this);
	}
	
	@Override
	public boolean onTouch(View v, MotionEvent event) {
		if (mEventFlg) {
			if (((ZoomRelativeLayout) v.getParent()).isZooming() == false) {
				v.getParent().requestDisallowInterceptTouchEvent(true);
				int x = (int) event.getRawX();
				int y = (int) event.getRawY();

				if (getTop() > y || getLeft() > x || (getLeft() + getWidth()) < x || (getTop() + getHeight()) < y) {
					setEvent(false, img3dIcon);
					return true;
				}

				switch (event.getAction()) {
					case MotionEvent.ACTION_DOWN:
						mOffsetX = x;
						mOffsetY = y;
						break;

					case MotionEvent.ACTION_UP:
					case MotionEvent.ACTION_CANCEL:
						setEvent(false, img3dIcon);
						break;

					case MotionEvent.ACTION_MOVE:
						int diffX = mOffsetX - x;
						int diffY = mOffsetY - y;

						if (Math.abs(diffX) > MOVE_RANGE_X) {
							if (diffX < 0) {
								if (mCurrentJ < (maxJ - 1)) {
									mCurrentJ++;
								} else {
									mCurrentJ = 0;
								}
							} else {
								if (mCurrentJ > 0) {
									mCurrentJ--;
								} else {
									mCurrentJ = maxJ - 1;
								}
							}
							mOffsetX = x;
						}
						if (Math.abs(diffY) > MOVE_RANGE_Y) {
							if (diffY < 0) {
								if (mCurrentI < (maxI - 1)) {
									mCurrentI++;
								} else {
									mCurrentI = 0;
								}
							} else {
								if (mCurrentI > 0) {
									mCurrentI--;
								} else {
									mCurrentI = maxI - 1;
								}
							}
							mOffsetY = y;
						}
						if (!(mCurrentI == mCurrentIBK && mCurrentJ == mCurrentJBK)) {
							MeetingManager meetingManager = MeetingManager.getInstance();
							if (meetingManager.isSendable()) {
								JSONObject json = new JSONObject();
								json.put(MeetingManager.FILE_NAME, FileUtil.getFileName(arrayImagePath[mCurrentI][mCurrentJ]));
								meetingManager.sendWs(MeetingManager.CMD_3DVIEWACTION, mContentId, mPage, mObjectId, json);
							}
							setCurrentImagePath(arrayImagePath[mCurrentI][mCurrentJ]);
							mCurrentIBK = mCurrentI;
							mCurrentJBK = mCurrentJ;
						}
						break;
				}
			}
		}
		return false;
	}

	private void setEvent(boolean eventFlg, ImageView imgIcon) {
		if (eventFlg == true) {
			mEventFlg = true;
			imgIcon.setVisibility(View.INVISIBLE);
		} else {
			mEventFlg = false;
			imgIcon.setVisibility(View.VISIBLE);
		}
	}
	public boolean getEventFlg() {
		return mEventFlg;
	}
	public void setPage(int page) {
		this.mPage = page;
	}
	public int getPage() {
		return mPage;
	}
	public void setCurrentImagePath(String path) {
		setImageURI(Uri.parse(path));
		this.mCurrentImagePath = path;
	}
	public String getCurrentImageUri() {
		return mCurrentImagePath;
	}
    public void setIndex(int index) {
    	mIndex = index;
    }
    public int getIndex() {
    	return mIndex;
    }
    
	public long getObjectId() {
		return mObjectId;
	}
}
