/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom;

import oz.lottie.custom.ContainerHelpers;

public class SparseArrayCompat
implements Cloneable {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArrayCompat() {
        this(10);
    }

    public SparseArrayCompat(int n) {
        if (n == 0) {
            this.mKeys = ContainerHelpers.EMPTY_INTS;
            this.mValues = ContainerHelpers.EMPTY_OBJECTS;
        } else {
            n = ContainerHelpers.idealIntArraySize(n);
            this.mKeys = new int[n];
            this.mValues = new Object[n];
        }
        this.mSize = 0;
    }

    public SparseArrayCompat clone() {
        SparseArrayCompat sparseArrayCompat;
        try {
            sparseArrayCompat = (SparseArrayCompat)super.clone();
            sparseArrayCompat.mKeys = (int[])this.mKeys.clone();
            sparseArrayCompat.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        return sparseArrayCompat;
    }

    public Object get(int n) {
        return this.get(n, null);
    }

    public Object get(int n, Object object) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 < 0 || this.mValues[n2] == DELETED) {
            return object;
        }
        return this.mValues[n2];
    }

    public void delete(int n) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0 && this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int n) {
        this.delete(n);
    }

    public void removeAt(int n) {
        if (this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    public void removeAtRange(int n, int n2) {
        int n3 = Math.min(this.mSize, n + n2);
        int n4 = n;
        while (n4 < n3) {
            this.removeAt(n4);
            ++n4;
        }
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            if (object != DELETED) {
                if (n3 != n2) {
                    nArray[n2] = nArray[n3];
                    objectArray[n2] = object;
                    objectArray[n3] = null;
                }
                ++n2;
            }
            ++n3;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    public void put(int n, Object object) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0) {
            this.mValues[n2] = object;
        } else {
            if ((n2 ^= 0xFFFFFFFF) < this.mSize && this.mValues[n2] == DELETED) {
                this.mKeys[n2] = n;
                this.mValues[n2] = object;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                n2 = ~ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
            }
            if (this.mSize >= this.mKeys.length) {
                int n3 = ContainerHelpers.idealIntArraySize(this.mSize + 1);
                int[] nArray = new int[n3];
                Object[] objectArray = new Object[n3];
                System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
                this.mKeys = nArray;
                this.mValues = objectArray;
            }
            if (this.mSize - n2 != 0) {
                System.arraycopy(this.mKeys, n2, this.mKeys, n2 + 1, this.mSize - n2);
                System.arraycopy(this.mValues, n2, this.mValues, n2 + 1, this.mSize - n2);
            }
            this.mKeys[n2] = n;
            this.mValues[n2] = object;
            ++this.mSize;
        }
    }

    public void putAll(SparseArrayCompat sparseArrayCompat) {
        int n = 0;
        int n2 = sparseArrayCompat.size();
        while (n < n2) {
            this.put(sparseArrayCompat.keyAt(n), sparseArrayCompat.valueAt(n));
            ++n;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public Object valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mValues[n];
    }

    public void setValueAt(int n, Object object) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = object;
    }

    public int indexOfKey(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
    }

    public int indexOfValue(Object object) {
        if (this.mGarbage) {
            this.gc();
        }
        int n = 0;
        while (n < this.mSize) {
            if (this.mValues[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean containsKey(int n) {
        return this.indexOfKey(n) >= 0;
    }

    public boolean containsValue(Object object) {
        return this.indexOfValue(object) >= 0;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = null;
            ++n2;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int n, Object object) {
        int n2;
        if (this.mSize != 0 && n <= this.mKeys[this.mSize - 1]) {
            this.put(n, object);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n2 = this.mSize) >= this.mKeys.length) {
            int n3 = ContainerHelpers.idealIntArraySize(n2 + 1);
            int[] nArray = new int[n3];
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        this.mKeys[n2] = n;
        this.mValues[n2] = object;
        this.mSize = n2 + 1;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.mSize * 28);
        stringBuilder.append('{');
        int n = 0;
        while (n < this.mSize) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            int n2 = this.keyAt(n);
            stringBuilder.append(n2);
            stringBuilder.append('=');
            Object object = this.valueAt(n);
            if (object != this) {
                stringBuilder.append(object);
            } else {
                stringBuilder.append("(this Map)");
            }
            ++n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

