/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import oz.lottie.custom.okio.SegmentPool;

final class Segment {
    static final int SIZE = 2048;
    final byte[] data = new byte[2048];
    int pos;
    int limit;
    Segment next;
    Segment prev;

    Segment() {
    }

    public Segment pop() {
        Segment segment = this.next != this ? this.next : null;
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return segment;
    }

    public Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public Segment split(int n) {
        int n2 = n;
        int n3 = this.limit - this.pos - n;
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < n3) {
            Segment segment = SegmentPool.INSTANCE.take();
            System.arraycopy(this.data, this.pos, segment.data, segment.pos, n2);
            this.pos += n2;
            segment.limit += n2;
            this.prev.push(segment);
            return segment;
        }
        Segment segment = SegmentPool.INSTANCE.take();
        System.arraycopy(this.data, this.pos + n2, segment.data, segment.pos, n3);
        this.limit -= n3;
        segment.limit += n3;
        this.push(segment);
        return this;
    }

    public void compact() {
        if (this.prev == this) {
            throw new IllegalStateException();
        }
        if (this.prev.limit - this.prev.pos + (this.limit - this.pos) > 2048) {
            return;
        }
        this.writeTo(this.prev, this.limit - this.pos);
        this.pop();
        SegmentPool.INSTANCE.recycle(this);
    }

    public void writeTo(Segment segment, int n) {
        if (n + (segment.limit - segment.pos) > 2048) {
            throw new IllegalArgumentException();
        }
        if (segment.limit + n > 2048) {
            System.arraycopy(segment.data, segment.pos, segment.data, 0, segment.limit - segment.pos);
            segment.limit -= segment.pos;
            segment.pos = 0;
        }
        System.arraycopy(this.data, this.pos, segment.data, segment.limit, n);
        segment.limit += n;
        this.pos += n;
    }
}

