/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix;

import java.util.List;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.DetectorResult;
import oz.util.barcode.datamatrix.decoder.Decoder;
import oz.util.barcode.datamatrix.detector.Detector;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        String string;
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = DataMatrixReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect();
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits());
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.DATA_MATRIX);
        List list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = DataMatrixReader.moduleSize(nArray, bitMatrix);
        int n2 = nArray[1];
        int n3 = nArray2[1];
        int n4 = nArray[0];
        int n5 = nArray2[0];
        int n6 = (n5 - n4 + 1) / n;
        int n7 = (n3 - n2 + 1) / n;
        if (n6 <= 0 || n7 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = n >> 1;
        n2 += n8;
        n4 += n8;
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        int n9 = 0;
        while (n9 < n7) {
            int n10 = n2 + n9 * n;
            int n11 = 0;
            while (n11 < n6) {
                if (bitMatrix.get(n4 + n11 * n, n10)) {
                    bitMatrix2.set(n11, n9);
                }
                ++n11;
            }
            ++n9;
        }
        return bitMatrix2;
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) {
        int n = bitMatrix.getWidth();
        int n2 = nArray[0];
        int n3 = nArray[1];
        while (n2 < n && bitMatrix.get(n2, n3)) {
            ++n2;
        }
        if (n2 == n) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n4 = n2 - nArray[0];
        if (n4 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n4;
    }
}

