/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import oz.util.barcode.datamatrix.encoder.C40Encoder;
import oz.util.barcode.datamatrix.encoder.EncoderContext;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;

final class X12Encoder
extends C40Encoder {
    X12Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 3;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            char c2 = encoderContext.getCurrentChar();
            ++encoderContext.pos;
            this.encodeChar(c2, stringBuilder);
            int n = stringBuilder.length();
            if (n % 3 != 0) continue;
            X12Encoder.writeNextTriplet(encoderContext, stringBuilder);
            int n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n2);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder);
    }

    @Override
    int encodeChar(char c2, StringBuilder stringBuilder) {
        if (c2 == '\r') {
            stringBuilder.append('\u0000');
        } else if (c2 == '*') {
            stringBuilder.append('\u0001');
        } else if (c2 == '>') {
            stringBuilder.append('\u0002');
        } else if (c2 == ' ') {
            stringBuilder.append('\u0003');
        } else if (c2 >= '0' && c2 <= '9') {
            stringBuilder.append((char)(c2 - 48 + 4));
        } else if (c2 >= 'A' && c2 <= 'Z') {
            stringBuilder.append((char)(c2 - 65 + 14));
        } else {
            HighLevelEncoder.illegalCharacter(c2);
        }
        return 1;
    }

    @Override
    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.updateSymbolInfo();
        int n = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
        int n2 = stringBuilder.length();
        if (n2 == 2) {
            encoderContext.writeCodeword('\u00fe');
            encoderContext.pos -= 2;
            encoderContext.signalEncoderChange(0);
        } else if (n2 == 1) {
            --encoderContext.pos;
            if (n > 1) {
                encoderContext.writeCodeword('\u00fe');
            }
            encoderContext.signalEncoderChange(0);
        }
    }
}

