/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.ArrayList;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.OneDReader;

public final class Code128Reader
extends OneDReader {
    static final int[][] CODE_PATTERNS = new int[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}, {2, 3, 3, 1, 1, 1, 2}};
    private static final int MAX_AVG_VARIANCE = 64;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    private static final int CODE_SHIFT = 98;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_STOP = 106;

    private static int[] findStartPattern(BitArray bitArray) {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        int n3 = 0;
        int[] nArray = new int[6];
        int n4 = n2;
        boolean bl = false;
        int n5 = nArray.length;
        int n6 = n2;
        while (n6 < n) {
            if (bitArray.get(n6) ^ bl) {
                int n7 = n3;
                nArray[n7] = nArray[n7] + 1;
            } else {
                if (n3 == n5 - 1) {
                    int n8 = 64;
                    int n9 = -1;
                    int n10 = 103;
                    while (n10 <= 105) {
                        int n11 = Code128Reader.patternMatchVariance(nArray, CODE_PATTERNS[n10], 179);
                        if (n11 < n8) {
                            n8 = n11;
                            n9 = n10;
                        }
                        ++n10;
                    }
                    if (n9 >= 0 && bitArray.isRange(Math.max(0, n4 - (n6 - n4) / 2), n4, false)) {
                        return new int[]{n4, n6, n9};
                    }
                    n4 += nArray[0] + nArray[1];
                    System.arraycopy(nArray, 2, nArray, 0, n5 - 2);
                    nArray[n5 - 2] = 0;
                    nArray[n5 - 1] = 0;
                    --n3;
                } else {
                    ++n3;
                }
                nArray[n3] = 1;
                bl = !bl;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeCode(BitArray bitArray, int[] nArray, int n) {
        Code128Reader.recordPattern(bitArray, n, nArray);
        int n2 = 64;
        int n3 = -1;
        int n4 = 0;
        while (n4 < CODE_PATTERNS.length) {
            int[] nArray2 = CODE_PATTERNS[n4];
            int n5 = Code128Reader.patternMatchVariance(nArray, nArray2, 179);
            if (n5 < n2) {
                n2 = n5;
                n3 = n4;
            }
            ++n4;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int n2;
        int n3;
        int n4;
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.ASSUME_GS1);
        int[] nArray = Code128Reader.findStartPattern(bitArray);
        int n5 = nArray[2];
        ArrayList<Byte> arrayList = new ArrayList<Byte>(20);
        arrayList.add((byte)n5);
        switch (n5) {
            case 103: {
                n4 = 101;
                break;
            }
            case 104: {
                n4 = 100;
                break;
            }
            case 105: {
                n4 = 99;
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        boolean bl2 = false;
        int n6 = 0;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n7 = nArray[0];
        int n8 = nArray[1];
        int[] nArray2 = new int[6];
        int n9 = 0;
        int n10 = 0;
        int n11 = n5;
        int n12 = 0;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        while (!bl2) {
            block70: {
                n3 = n6;
                n6 = 0;
                n9 = n10;
                n10 = Code128Reader.decodeCode(bitArray, nArray2, n8);
                arrayList.add((byte)n10);
                if (n10 != 106) {
                    bl3 = true;
                }
                if (n10 != 106) {
                    n11 += ++n12 * n10;
                }
                n7 = n8;
                int[] nArray3 = nArray2;
                int n13 = nArray2.length;
                int n14 = 0;
                while (n14 < n13) {
                    n2 = nArray3[n14];
                    n8 += n2;
                    ++n14;
                }
                switch (n10) {
                    case 103: 
                    case 104: 
                    case 105: {
                        throw FormatException.getFormatInstance();
                    }
                }
                block8 : switch (n4) {
                    case 101: {
                        if (n10 < 64) {
                            if (bl5 == bl4) {
                                stringBuilder.append((char)(32 + n10));
                            } else {
                                stringBuilder.append((char)(32 + n10 + 128));
                            }
                            bl5 = false;
                            break;
                        }
                        if (n10 < 96) {
                            if (bl5 == bl4) {
                                stringBuilder.append((char)(n10 - 64));
                            } else {
                                stringBuilder.append((char)(n10 + 64));
                            }
                            bl5 = false;
                            break;
                        }
                        if (n10 != 106) {
                            bl3 = false;
                        }
                        switch (n10) {
                            case 102: {
                                if (!bl) break;
                                if (stringBuilder.length() == 0) {
                                    stringBuilder.append("]C1");
                                    break;
                                }
                                stringBuilder.append('\u001d');
                                break;
                            }
                            case 96: 
                            case 97: {
                                break;
                            }
                            case 101: {
                                if (!bl4 && bl5) {
                                    bl4 = true;
                                    bl5 = false;
                                    break;
                                }
                                if (bl4 && bl5) {
                                    bl4 = false;
                                    bl5 = false;
                                    break;
                                }
                                bl5 = true;
                                break;
                            }
                            case 98: {
                                n6 = 1;
                                n4 = 100;
                                break;
                            }
                            case 100: {
                                n4 = 100;
                                break;
                            }
                            case 99: {
                                n4 = 99;
                                break;
                            }
                            case 106: {
                                bl2 = true;
                            }
                        }
                        break;
                    }
                    case 100: {
                        if (n10 < 96) {
                            if (bl5 == bl4) {
                                stringBuilder.append((char)(32 + n10));
                            } else {
                                stringBuilder.append((char)(32 + n10 + 128));
                            }
                            bl5 = false;
                            break;
                        }
                        if (n10 != 106) {
                            bl3 = false;
                        }
                        switch (n10) {
                            case 102: {
                                if (!bl) break;
                                if (stringBuilder.length() == 0) {
                                    stringBuilder.append("]C1");
                                    break;
                                }
                                stringBuilder.append('\u001d');
                                break;
                            }
                            case 96: 
                            case 97: {
                                break;
                            }
                            case 100: {
                                if (!bl4 && bl5) {
                                    bl4 = true;
                                    bl5 = false;
                                    break;
                                }
                                if (bl4 && bl5) {
                                    bl4 = false;
                                    bl5 = false;
                                    break;
                                }
                                bl5 = true;
                                break;
                            }
                            case 98: {
                                n6 = 1;
                                n4 = 101;
                                break;
                            }
                            case 101: {
                                n4 = 101;
                                break;
                            }
                            case 99: {
                                n4 = 99;
                                break;
                            }
                            case 106: {
                                bl2 = true;
                            }
                        }
                        break;
                    }
                    case 99: {
                        if (n10 < 100) {
                            if (n10 < 10) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(n10);
                            break;
                        }
                        if (n10 != 106) {
                            bl3 = false;
                        }
                        switch (n10) {
                            case 102: {
                                if (bl) {
                                    if (stringBuilder.length() == 0) {
                                        stringBuilder.append("]C1");
                                        break block8;
                                    }
                                    stringBuilder.append('\u001d');
                                    break block8;
                                }
                                break block70;
                            }
                            case 101: {
                                n4 = 101;
                                break block8;
                            }
                            case 100: {
                                n4 = 100;
                                break block8;
                            }
                            case 106: {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
            if (n3 == 0) continue;
            int n15 = n4 = n4 == 101 ? 100 : 101;
        }
        n3 = n8 - n7;
        if (!bitArray.isRange(n8 = bitArray.getNextUnset(n8), Math.min(bitArray.getSize(), n8 + (n8 - n7) / 2), false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((n11 -= n12 * n9) % 103 != n9) {
            throw ChecksumException.getChecksumInstance();
        }
        n2 = stringBuilder.length();
        if (n2 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n2 > 0 && bl3) {
            if (n4 == 99) {
                stringBuilder.delete(n2 - 2, n2);
            } else {
                stringBuilder.delete(n2 - 1, n2);
            }
        }
        float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f3 = (float)n7 + (float)n3 / 2.0f;
        int n16 = arrayList.size();
        byte[] byArray = new byte[n16];
        int n17 = 0;
        while (n17 < n16) {
            byArray[n17] = (Byte)arrayList.get(n17);
            ++n17;
        }
        return new Result(stringBuilder.toString(), byArray, new ResultPoint[]{new ResultPoint(f2, n), new ResultPoint(f3, n)}, BarcodeFormat.CODE_128);
    }
}

