/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned.rss.expanded.decoders;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.rss.expanded.decoders.AI01decoder;
import oz.util.barcode.oned.rss.expanded.decoders.DecodedInformation;

final class AI01392xDecoder
extends AI01decoder {
    private static final int HEADER_SIZE = 8;
    private static final int LAST_DIGIT_SIZE = 2;

    AI01392xDecoder(BitArray bitArray) {
        super(bitArray);
    }

    @Override
    public String parseInformation() {
        if (this.getInformation().getSize() < 48) {
            throw NotFoundException.getNotFoundInstance();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.encodeCompressedGtin(stringBuilder, 8);
        int n = this.getGeneralDecoder().extractNumericValueFromBitArray(48, 2);
        stringBuilder.append("(392");
        stringBuilder.append(n);
        stringBuilder.append(')');
        DecodedInformation decodedInformation = this.getGeneralDecoder().decodeGeneralPurposeField(50, null);
        stringBuilder.append(decodedInformation.getNewString());
        return stringBuilder.toString();
    }
}

