/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CalendarView;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import android.widget.TimePicker;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.threeten.bp.LocalDate;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;
import oz.main.OZStorage;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.MaterialCalendarView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFClearButton$Builder;
import oz.viewer.ui.df.view.DFInputCompDate$1;
import oz.viewer.ui.df.view.DFInputCompDate$DFDateInterface;
import oz.viewer.ui.df.view.DFInputCompDate$TimeInfo;
import oz.viewer.ui.df.view.DFInputCompView;

public class DFInputCompDate
extends DFInputCompView
implements View.OnClickListener {
    private static final String TEXT_RES_EMPTY_MSG = "datetimepicker.empty.msg";
    private boolean mTimePicker;
    private String mPattern;
    private long mDate;
    private boolean mIsCaptionEmpty;
    private boolean mIsAllowEmpty;
    private Button mResetButton;
    private boolean isClickedDateTimePicker;
    private LinearLayout root;
    private LinearLayout dateTimePickerLayout = null;
    private DatePicker dp;
    private TimePicker tp;
    private TextView tv;
    private DFInputCompDate$TimeInfo mTime = new DFInputCompDate$TimeInfo(this, null);
    private DFInputCompDate$TimeInfo mMinTime = new DFInputCompDate$TimeInfo(this, null);
    private DFInputCompDate$TimeInfo mMaxTime = new DFInputCompDate$TimeInfo(this, null);
    private MaterialCalendarView calendar;
    private CalendarDay oldCalendarDay = null;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern((String)"yyyy-MM-dd");

    public DFInputCompDate(Context context, DFInputCompDate$DFDateInterface dFInputCompDate$DFDateInterface) {
        super(context, dFInputCompDate$DFDateInterface);
    }

    private DFInputCompDate$DFDateInterface getInterface() {
        return (DFInputCompDate$DFDateInterface)this.getDFInterface();
    }

    protected void create(int n, int n2) {
        this.mPattern = this.getInterface().getPattern();
        this.mDate = this.getInterface().getDateValue();
        this.mMinTime.setDate(this.getInterface().getMinDate());
        this.mMaxTime.setDate(this.getInterface().getMaxDate());
        this.mIsCaptionEmpty = this.getInterface().isCaptionEmpty();
        this.mIsAllowEmpty = this.getInterface().isAllowEmpty();
        this.createCalendarView();
    }

    protected void updateSizeChanged(int n, int n2) {
        this.updateDTPLayout();
    }

    protected void updateInternal(boolean bl) {
        if (bl) {
            DFInputCompDate$TimeInfo dFInputCompDate$TimeInfo = new DFInputCompDate$TimeInfo(this, null);
            dFInputCompDate$TimeInfo.setDate(this.getValue().toString());
            LocalDate localDate = LocalDate.of((int)dFInputCompDate$TimeInfo.year, (int)dFInputCompDate$TimeInfo.month, (int)dFInputCompDate$TimeInfo.day);
            CalendarDay calendarDay = CalendarDay.from(localDate);
            this.calendar.clearSelection();
            if (calendarDay != null) {
                this.calendar.setDateSelected(calendarDay, true);
            }
        }
    }

    public void callOnValueChanged() {
        if (this.calendar != null) {
            CalendarDay calendarDay = this.calendar.getSelectedDate();
            if (calendarDay != null) {
                Date date;
                String string = FORMATTER.format((TemporalAccessor)calendarDay.getDate());
                int n = Calendar.getInstance().getTime().getSeconds();
                String string2 = String.format("%s:%s:%d", String.format("%02d", this.tp.getCurrentHour()), String.format("%02d", this.tp.getCurrentMinute()), n);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    date = simpleDateFormat.parse(String.format("%s %s", string, string2));
                }
                catch (ParseException parseException) {
                    Log.e((String)"OZViewer", (String)("Not supported pattern(confirm) : " + parseException.getLocalizedMessage()));
                    date = new Date();
                }
                this.setValue(String.valueOf(date.getTime()));
            } else {
                this.setValue(null);
            }
        }
        super.callOnValueChanged();
    }

    private void updateDTPLayout() {
        if (this.dateTimePickerLayout != null) {
            this.root.removeView((View)this.dateTimePickerLayout);
        }
        boolean bl = DFUtils.isMobile(this.getContext());
        this.dateTimePickerLayout = new LinearLayout(this.getContext());
        int n = this.getResources().getConfiguration().orientation;
        if (n == 1) {
            this.dateTimePickerLayout.setOrientation(1);
        } else if (n == 2) {
            this.dateTimePickerLayout.setOrientation(0);
        }
        this.calendar = new MaterialCalendarView(this.getContext());
        this.calendar.setShowOtherDates(7);
        this.calendar.setLeftArrow(DFUtils.getImageDrawable(this.getContext(), 24));
        this.calendar.setRightArrow(DFUtils.getImageDrawable(this.getContext(), 25));
        this.calendar.setOnTouchListener(this.DFOnTouchListener);
        LocalDate localDate = LocalDate.of((int)this.mTime.year, (int)this.mTime.month, (int)this.mTime.day);
        LocalDate localDate2 = LocalDate.of((int)this.mMinTime.year, (int)this.mMinTime.month, (int)this.mMinTime.day);
        LocalDate localDate3 = LocalDate.of((int)this.mMaxTime.year, (int)this.mMaxTime.month, (int)this.mMaxTime.day);
        this.calendar.state().edit().setMinimumDate(localDate2).setMaximumDate(localDate3).commit();
        CalendarDay calendarDay = CalendarDay.from(localDate);
        if (calendarDay != null) {
            this.calendar.setDateSelected(calendarDay, true);
            this.oldCalendarDay = calendarDay;
        }
        this.calendar.setOnDateChangedListener(new DFInputCompDate$1(this));
        int n2 = this.getInterface().getItemWidth();
        int n3 = this.getInterface().getItemHeight();
        int n4 = n2 > n3 ? (bl ? n3 * 3 / 5 : n3 * 2 / 5) : (bl ? n2 * 3 / 4 : n2 / 2);
        this.dateTimePickerLayout.addView((View)this.calendar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n4, n4));
        this.tp = new TimePicker(this.getContext(), null, 1);
        this.tp.setCurrentHour(Integer.valueOf(this.mTime.hour));
        this.tp.setCurrentMinute(Integer.valueOf(this.mTime.min));
        this.tp.setIs24HourView(Boolean.valueOf(true));
        int n5 = Resources.getSystem().getIdentifier("hour", "id", "android");
        int n6 = Resources.getSystem().getIdentifier("minute", "id", "android");
        int n7 = Resources.getSystem().getIdentifier("amPm", "id", "android");
        NumberPicker numberPicker = (NumberPicker)this.tp.findViewById(n5);
        NumberPicker numberPicker2 = (NumberPicker)this.tp.findViewById(n6);
        this.setNumberPickerTextColor(numberPicker, -1);
        this.setNumberPickerTextColor(numberPicker2, -1);
        if (this.mTimePicker) {
            this.tp.setPadding(OZStorage.padding_10, 0, OZStorage.padding_10, OZStorage.padding_10);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 16;
            this.dateTimePickerLayout.addView((View)this.tp, (ViewGroup.LayoutParams)layoutParams);
        }
        this.root.addView((View)this.dateTimePickerLayout, 0);
    }

    private void createCalendarView() {
        this.setComponentText();
        this.root = new LinearLayout(this.getContext());
        this.root.setOrientation(1);
        this.updateDTPLayout();
        this.root.addView(this.createConfirmBtn((ViewGroup)this.root));
        this.addView((View)this.root);
        if (this.mIsAllowEmpty) {
            this.mResetButton = new DFClearButton$Builder((ViewGroup)this).setOnClickListener(this).setSizeDP(40).setLayoutGravity(53).setLayoutMarginRightDP(10).setLayoutMarginTopDP(10).create();
            this.addView((View)this.mResetButton);
        }
    }

    private void setNumberPickerTextColor(NumberPicker numberPicker, int n) {
        int n2 = numberPicker.getChildCount();
        for (int j = 0; j < n2; ++j) {
            View view = numberPicker.getChildAt(j);
            try {
                Field field = numberPicker.getClass().getDeclaredField("mSelectorWheelPaint");
                field.setAccessible(true);
                ((Paint)field.get(numberPicker)).setColor(n);
                ((EditText)view).setTextColor(n);
                numberPicker.invalidate();
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.w((String)"setNumberPickerTextColor", (Throwable)noSuchFieldException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)"setNumberPickerTextColor", (Throwable)illegalAccessException);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"setNumberPickerTextColor", (Throwable)illegalArgumentException);
            }
        }
    }

    private String getMinMaxPattern(String string) {
        if (string.matches("^[0-9]{2}/[0-9]{2}/[0-9]{4}$")) {
            return "MM/dd/yyyy";
        }
        return this.mPattern;
    }

    private void setComponentText() {
        if (this.mPattern.startsWith("date_")) {
            this.mPattern = this.mPattern.substring(5);
        } else if (this.mPattern.startsWith("d_") || this.mPattern.startsWith("D_")) {
            this.mPattern = this.mPattern.substring(2);
        } else if ("STRING".equals(this.mPattern)) {
            this.mPattern = "yyyy-MM-dd";
        }
        if (this.mPattern.startsWith("ggge") || this.mPattern.startsWith("ge")) {
            this.mPattern = "yyyy-MM-dd";
        }
        this.mTimePicker = this.isExistTimePattern(this.mPattern);
        Date date = new Date(this.mDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.mTimePicker) {
            this.mTime.setDateTime(calendar);
        } else {
            this.mTime.setDate(calendar);
        }
    }

    private boolean isExistTimePattern(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf("'");
        while (n > -1) {
            int n2 = stringBuilder.indexOf("'", n + 1);
            if (n2 > -1) {
                stringBuilder.delete(n, n2 + 1);
            } else {
                stringBuilder.delete(n, stringBuilder.length());
            }
            n = stringBuilder.indexOf("'");
        }
        string = stringBuilder.toString();
        return !string.equalsIgnoreCase("STRING") && (string.indexOf("H") >= 0 || string.indexOf("h") >= 0 || string.indexOf("m") >= 0 || string.indexOf("S") >= 0 || string.indexOf("s") >= 0);
    }

    private int[] splitDate(String string, String object) {
        Object object2;
        int[] nArray = new int[5];
        Date date = null;
        try {
            object2 = "";
            if (!(((String)object).equalsIgnoreCase("STRING") || ((String)object).indexOf("yy") >= 0 && ((String)object).indexOf("MM") >= 0 && ((String)object).indexOf("dd") >= 0)) {
                String string2;
                object2 = "yyyy-MM-dd";
                int n = -1;
                int n2 = ((String)object).indexOf("H");
                n = n2 == -1 ? Math.min(((String)object).indexOf("h"), ((String)object).indexOf("m")) : Math.min(((String)object).indexOf("H"), ((String)object).indexOf("m"));
                if (n != -1 && !"".equals(string2 = ((String)object).substring(n))) {
                    object2 = (String)object2 + string2;
                }
                object = object2;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object, OZStorage.getViewerLocale());
            date = !"".equals(string) ? simpleDateFormat.parse(string) : new Date();
        }
        catch (Exception exception) {
            Log.e((String)"OZViewer", (String)("Not supported pattern : " + exception.getLocalizedMessage()));
            object = "yyyy-MM-dd";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object, OZStorage.getViewerLocale());
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                Log.e((String)"OZViewer", (String)("Not supported text : " + parseException.getLocalizedMessage()));
                date = new Date();
            }
        }
        object2 = Calendar.getInstance();
        ((Calendar)object2).setTime(date);
        nArray[0] = ((Calendar)object2).get(1);
        nArray[1] = ((Calendar)object2).get(2) + 1;
        nArray[2] = ((Calendar)object2).get(5);
        nArray[3] = ((Calendar)object2).get(11);
        nArray[4] = ((Calendar)object2).get(12);
        return nArray;
    }

    private void setDatePickerMinMax() {
        Date date = this.mMaxTime.toDate();
        Date date2 = this.mMinTime.toDate();
        if (date.getTime() < date2.getTime()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                date = simpleDateFormat.parse("9998-12-31 23:59:59.999");
                date2 = simpleDateFormat.parse("1753-01-01 00:00:00.000");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        this.dp.setMaxDate(date.getTime());
        this.dp.setMinDate(date2.getTime());
    }

    private void setUseCalendar() {
        try {
            this.dp.setCalendarViewShown(this.ableUseCalendar());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean ableUseCalendar() {
        long l;
        long l2 = 1209600000L;
        long l3 = this.dp.getMaxDate();
        if (l3 - (l = this.dp.getMinDate()) >= l2) {
            if (this.mTimePicker) {
                if (OZStorage.isSmallDevice(this.getContext())) {
                    return false;
                }
                try {
                    CalendarView calendarView = this.dp.getCalendarView();
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)calendarView.getLayoutParams();
                    layoutParams.height = OZStorage.DpToPx(this.getContext(), 200.0f, false);
                    calendarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    calendarView.setShownWeekCount(4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public void onClick(View view) {
        this.calendar.clearSelection();
        this.tp.setCurrentHour(Integer.valueOf(0));
        this.tp.setCurrentMinute(Integer.valueOf(0));
    }

    static /* synthetic */ String access$000(DFInputCompDate dFInputCompDate, String string) {
        return dFInputCompDate.getMinMaxPattern(string);
    }

    static /* synthetic */ int[] access$100(DFInputCompDate dFInputCompDate, String string, String string2) {
        return dFInputCompDate.splitDate(string, string2);
    }

    static /* synthetic */ DFInputCompDate$TimeInfo access$200(DFInputCompDate dFInputCompDate) {
        return dFInputCompDate.mMaxTime;
    }

    static /* synthetic */ boolean access$400(DFInputCompDate dFInputCompDate) {
        return dFInputCompDate.mIsAllowEmpty;
    }

    static /* synthetic */ CalendarDay access$500(DFInputCompDate dFInputCompDate) {
        return dFInputCompDate.oldCalendarDay;
    }

    static /* synthetic */ CalendarDay access$502(DFInputCompDate dFInputCompDate, CalendarDay calendarDay) {
        dFInputCompDate.oldCalendarDay = calendarDay;
        return dFInputCompDate.oldCalendarDay;
    }

    static /* synthetic */ MaterialCalendarView access$600(DFInputCompDate dFInputCompDate) {
        return dFInputCompDate.calendar;
    }
}

