package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

/**
 * 規約同意のAPIで使うレスポンス
 */
public class AgreementToTermsJSON extends AcmsCommonJSON {

    private static final String TERMS_VERSION = "termsVersion";
    private static final String TERMS = "terms";

    private String termsVersion;
    private String terms;

    public AgreementToTermsJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException, JSONException {
        super.parse(json);
        termsVersion = json.has(TERMS_VERSION) ? json.getString(TERMS_VERSION) : "";
        terms = json.has(TERMS) ? json.getString(TERMS) : "";
    }

    /**
     * @return  規約のバージョン
     */
    public String getTermsVersion() {
        return termsVersion;
    }

    /**
     * @return  規約の内容
     */
    public String getTerms() {
        return terms;
    }
}
