package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * 規約同意時に使用するパラメータ
 */
public class AgreementToTermsParameters extends HttpParameterObject {
    private final String sid;
    private final String termsVersion;

    /**
     * @param sid   セッションID
     * @param termsVersion  同意した規約のバージョン
     */
    public AgreementToTermsParameters(String sid, String termsVersion) {
        super();
        this.sid = sid;
        this.termsVersion = termsVersion;
    }

    /**
     * @return  セッションID
     */
    public String getSid() {
        return sid;
    }

    /**
     * @return  同意した規約のバージョン
     */
    public String getTermsVersion() {
        return termsVersion;
    }
}
