package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link GetNameCardParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class GetNameCardParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private String nameCardMemberId;

	/**
	 * {@link GetNameCardParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public GetNameCardParameters(String sid) {
		this.sid = sid;
	}

	/**
	 * {@link GetNameCardParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @param nameCardMemberId 対象ユーザID。
	 * @since 1.0.0
	 */
	public GetNameCardParameters(String sid, String cmd, String nameCardMemberId) {
		this.sid = sid;
		this.cmd = cmd;
		this.nameCardMemberId = nameCardMemberId;
	}

	public String getSid() {
		return sid;
	}

	public String getCmd() {
		return cmd;
	}

	public String getNameCardMemberId() {
		return nameCardMemberId;
	}

}
