package jp.agentec.abook.abv.ui.viewer.activity;

import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import java.io.File;
import java.io.FileNotFoundException;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.ui.common.activity.ABVAuthenticatedActivity;
import jp.agentec.abook.abv.ui.home.helper.ABookCheckWebViewHelper;

public class CommunicationWebViewActivity extends ABVAuthenticatedActivity {
    private static final String TAG = "CommunicationWebViewActivity";

    private LinearLayout historyLayout;
    private ImageButton addSceneButton;

    protected ImageButton promoteBtn;
    protected ImageButton pauseBtn;
    protected ImageButton mBtnRemoteStart;
    protected Button historyListBtn;
    protected ImageButton btnWebClose;
    protected Button closeButton;
    protected Button btnLinkOriginalBack;
    protected Button btnWebBack;
    protected Button btnWebForward;
    private ProgressBar m_progress;
    protected ContentDto mContentDto;
    protected File mLocalFile;

    @Override
    protected void onDestroy() {
        Logger.d(TAG, "onDestroy");
        super.onDestroy();
    }


    protected Uri attachmentImageProcessing(Uri uri) throws Exception {
        if (uri == null) {
            return null;
        }
        String[] operationion = {MediaStore.MediaColumns.DATA};
        Cursor cursor = getContentResolver().query(uri, operationion, null, null, null);
        String photoFilePath = ABookCheckWebViewHelper.getInstance().contentSchemeUriToFilePath(cursor);
        try {
            int rotationAngle = ABookCheckWebViewHelper.getInstance().rotateBitmapOrientation(photoFilePath);
            mLocalFile = new File(photoFilePath);
            if (mLocalFile.exists()) {
                return Uri.fromFile(mLocalFile);
            }
        } catch (FileNotFoundException e) {
            Logger.e(TAG, "image file is not found", e);
        }
        return null;
    }
}
