/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.View;
import java.util.Locale;
import oz.client.shape.ui.ICSignPadWnd;
import oz.util.OZByte6Array;

public class OZSignViewBase
extends View {
    private ICSignPadWnd mParent;
    private RectF mOriginalSize;
    private RectF mCompSize;

    public OZSignViewBase(Context context, ICSignPadWnd iCSignPadWnd, float f2, float f3) {
        super(context);
        this.mParent = iCSignPadWnd;
        this.mOriginalSize = new RectF(0.0f, 0.0f, f2, f3);
        this.mCompSize = new RectF(this.getOriginalSize());
    }

    public ICSignPadWnd getICParent() {
        return this.mParent;
    }

    protected void setOriginalSize(float f2, float f3, float f4, float f5) {
        this.mOriginalSize.set(f2, f3, f4, f5);
    }

    public RectF getOriginalSize() {
        return this.mOriginalSize;
    }

    public RectF getCompSize() {
        return this.mCompSize;
    }

    private int getBytesLength_1Byte() {
        int n = this.getICParent().getSignBytesLength();
        return n & 0xF;
    }

    private int getBytesLength_2Bytes() {
        int n = this.getICParent().getSignBytesLength();
        return (n >>> 4 & 0xF) + (n & 0xF);
    }

    protected byte[] getExtra_2Bytes(long l, float f2, long l2) {
        if (this.getBytesLength_2Bytes() == 8) {
            int n = (int)(l / 1000L);
            byte[] byArray = new byte[8];
            byArray[0] = (byte)(n >>> 24 & 0xFF);
            byArray[1] = (byte)(n >>> 16 & 0xFF);
            byArray[2] = (byte)(n >>> 8 & 0xFF);
            byArray[3] = (byte)(n >>> 0 & 0xFF);
            n = (int)(l - l2);
            int n2 = (int)(4095.0f * f2);
            byArray[4] = (byte)(n >>> 12 & 0xFF);
            byArray[5] = (byte)(n >>> 4 & 0xFF);
            byArray[6] = (byte)(n << 4 & 0xF0 | n2 >>> 8 & 0xF);
            byArray[7] = (byte)(n2 >>> 0 & 0xFF);
            return byArray;
        }
        return null;
    }

    protected long appendExtra_1Byte(float f2, long l) {
        long l2 = System.currentTimeMillis();
        this.appendExtra_1Byte(l2, f2, l);
        return l2;
    }

    protected byte[] getExtra_1Bytes(long l, float f2, long l2) {
        int n = (int)(4095.0f * f2);
        int n2 = (int)(l / 1000L);
        byte[] byArray = new byte[4];
        n2 = (int)(l - l2);
        byArray[0] = (byte)(n2 >>> 12 & 0xFF);
        byArray[1] = (byte)(n2 >>> 4 & 0xFF);
        byArray[2] = (byte)(n2 << 4 & 0xF0 | n >>> 8 & 0xF);
        byArray[3] = (byte)(n >>> 0 & 0xFF);
        return byArray;
    }

    protected void appendExtra_1Byte(long l, float f2, long l2) {
        if (this.getBytesLength_1Byte() == 4) {
            this.appendExtra(this.getExtra_1Bytes(l, f2, l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendExtraInternal(StringBuffer stringBuffer, OZByte6Array oZByte6Array, byte[] byArray, int n) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.append(':');
            stringBuffer.append(oZByte6Array.toString());
            stringBuffer.append(' ');
        }
    }

    protected void appendExtra(byte[] byArray) {
        if (byArray != null) {
            this.appendExtra(byArray, byArray.length);
        }
    }

    protected void appendExtra(byte[] byArray, int n) {
        if (n == 0) {
            return;
        }
        OZByte6Array oZByte6Array = new OZByte6Array(n);
        for (int j = 0; j < n; ++j) {
            oZByte6Array.set(j, byArray[j]);
        }
        this.appendExtraInternal(this.getICParent().getSignPathData(), oZByte6Array, byArray, n);
        if (this.getICParent().isEmptyComponent()) {
            this.appendExtraInternal(this.getICParent().getSignPathLastData(), oZByte6Array, byArray, n);
        }
    }

    private void appendPointInternal(StringBuffer stringBuffer, String string, float f2, float f3) {
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(String.format(Locale.ENGLISH, "%.3f", Float.valueOf(f2 / this.getOriginalSize().width())));
        stringBuffer.append(",");
        stringBuffer.append(String.format(Locale.ENGLISH, "%.3f", Float.valueOf(f3 / this.getOriginalSize().height())));
    }

    protected void appendPoint(String string, PointF pointF) {
        this.appendPoint(string, pointF.x, pointF.y);
    }

    protected void appendPoint(String string, float f2, float f3) {
        this.appendPointInternal(this.getICParent().getSignPathData(), string, f2, f3);
        if (this.getICParent().isEmptyComponent()) {
            this.appendPointInternal(this.getICParent().getSignPathLastData(), string, f2, f3);
        }
    }

    protected void appendPointWithExtra(String string, PointF pointF, byte[] byArray) {
        this.appendPoint(string, pointF);
        this.appendExtra(byArray);
    }

    protected long appendPointWithExtra_1Byte(String string, PointF pointF, float f2, long l) {
        this.appendPoint(string, pointF);
        return this.appendExtra_1Byte(f2, l);
    }

    protected void appendPointWithExtra_1Byte(String string, PointF pointF, long l, float f2, long l2) {
        this.appendPoint(string, pointF);
        this.appendExtra_1Byte(l, f2, l2);
    }

    protected void appendEnd() {
        if (this.getICParent().isEmptyComponent()) {
            this.getICParent().getSignPathLastData().setLength(0);
        }
    }
}

