/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.L;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.DrawingContent;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.GradientColor;
import oz.lottie.model.content.GradientFill;
import oz.lottie.model.content.GradientType;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;

public class GradientFillContent
implements DrawingContent,
KeyPathElementContent,
BaseKeyframeAnimation$AnimationListener {
    private static final int CACHE_STEPS_MS = 32;
    private final String name;
    private final boolean hidden;
    private final BaseLayer layer;
    private final LongSparseArray linearGradientCache = new LongSparseArray();
    private final LongSparseArray radialGradientCache = new LongSparseArray();
    private final Path path = new Path();
    private final Paint paint = new LPaint(1);
    private final RectF boundsRect = new RectF();
    private final List paths = new ArrayList();
    private final GradientType type;
    private final BaseKeyframeAnimation colorAnimation;
    private final BaseKeyframeAnimation opacityAnimation;
    private final BaseKeyframeAnimation startPointAnimation;
    private final BaseKeyframeAnimation endPointAnimation;
    private BaseKeyframeAnimation colorFilterAnimation;
    private ValueCallbackKeyframeAnimation colorCallbackAnimation;
    private final LottieDrawable lottieDrawable;
    private final int cacheSteps;

    public GradientFillContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, GradientFill gradientFill) {
        this.layer = baseLayer;
        this.name = gradientFill.getName();
        this.hidden = gradientFill.isHidden();
        this.lottieDrawable = lottieDrawable;
        this.type = gradientFill.getGradientType();
        this.path.setFillType(gradientFill.getFillType());
        this.cacheSteps = (int)(lottieDrawable.getComposition().getDuration() / 32.0f);
        this.colorAnimation = gradientFill.getGradientColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.colorAnimation);
        this.opacityAnimation = gradientFill.getOpacity().createAnimation();
        this.opacityAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.opacityAnimation);
        this.startPointAnimation = gradientFill.getStartPoint().createAnimation();
        this.startPointAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.startPointAnimation);
        this.endPointAnimation = gradientFill.getEndPoint().createAnimation();
        this.endPointAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.endPointAnimation);
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < list2.size()) {
            Content content = (Content)list2.get(n);
            if (content instanceof PathContent) {
                this.paths.add((PathContent)content);
            }
            ++n;
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        if (this.hidden) {
            return;
        }
        L.beginSection("GradientFillContent#draw");
        this.path.reset();
        int n2 = 0;
        while (n2 < this.paths.size()) {
            this.path.addPath(((PathContent)this.paths.get(n2)).getPath(), matrix);
            ++n2;
        }
        this.path.computeBounds(this.boundsRect, false);
        Object object = this.type == GradientType.LINEAR ? this.getLinearGradient() : this.getRadialGradient();
        object.setLocalMatrix(matrix);
        this.paint.setShader((Shader)object);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter((ColorFilter)this.colorFilterAnimation.getValue());
        }
        int n3 = (int)((float)n / 255.0f * (float)((Integer)this.opacityAnimation.getValue()).intValue() / 100.0f * 255.0f);
        this.paint.setAlpha(MiscUtils.clamp(n3, 0, 255));
        canvas.drawPath(this.path, this.paint);
        L.endSection("GradientFillContent#draw");
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        this.path.reset();
        int n = 0;
        while (n < this.paths.size()) {
            this.path.addPath(((PathContent)this.paths.get(n)).getPath(), matrix);
            ++n;
        }
        this.path.computeBounds(rectF, false);
        rectF.set(rectF.left - 1.0f, rectF.top - 1.0f, rectF.right + 1.0f, rectF.bottom + 1.0f);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private LinearGradient getLinearGradient() {
        int n = this.getGradientHash();
        LinearGradient linearGradient = (LinearGradient)this.linearGradientCache.get((long)n);
        if (linearGradient != null) {
            return linearGradient;
        }
        PointF pointF = (PointF)this.startPointAnimation.getValue();
        PointF pointF2 = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] nArray = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] fArray = gradientColor.getPositions();
        linearGradient = new LinearGradient(pointF.x, pointF.y, pointF2.x, pointF2.y, nArray, fArray, Shader.TileMode.CLAMP);
        this.linearGradientCache.put((long)n, (Object)linearGradient);
        return linearGradient;
    }

    private RadialGradient getRadialGradient() {
        int n = this.getGradientHash();
        RadialGradient radialGradient = (RadialGradient)this.radialGradientCache.get((long)n);
        if (radialGradient != null) {
            return radialGradient;
        }
        PointF pointF = (PointF)this.startPointAnimation.getValue();
        PointF pointF2 = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] nArray = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] fArray = gradientColor.getPositions();
        float f2 = pointF2.x;
        float f3 = pointF.x;
        float f4 = pointF2.y;
        float f5 = pointF.y;
        float f6 = (float)Math.hypot(f2 - f3, f4 - f5);
        if (f6 <= 0.0f) {
            f6 = 0.001f;
        }
        radialGradient = new RadialGradient(f3, f5, f6, nArray, fArray, Shader.TileMode.CLAMP);
        this.radialGradientCache.put((long)n, (Object)radialGradient);
        return radialGradient;
    }

    private int getGradientHash() {
        int n = Math.round(this.startPointAnimation.getProgress() * (float)this.cacheSteps);
        int n2 = Math.round(this.endPointAnimation.getProgress() * (float)this.cacheSteps);
        int n3 = Math.round(this.colorAnimation.getProgress() * (float)this.cacheSteps);
        int n4 = 17;
        if (n != 0) {
            n4 = n4 * 31 * n;
        }
        if (n2 != 0) {
            n4 = n4 * 31 * n2;
        }
        if (n3 != 0) {
            n4 = n4 * 31 * n3;
        }
        return n4;
    }

    private int[] applyDynamicColorsIfNeeded(int[] nArray) {
        block4: {
            if (this.colorCallbackAnimation == null) break block4;
            Integer[] integerArray = (Integer[])this.colorCallbackAnimation.getValue();
            if (nArray.length == integerArray.length) {
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = integerArray[n];
                    ++n;
                }
            } else {
                nArray = new int[integerArray.length];
                int n = 0;
                while (n < integerArray.length) {
                    nArray[n] = integerArray[n];
                    ++n;
                }
            }
        }
        return nArray;
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.OPACITY) {
            this.opacityAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.COLOR_FILTER) {
            if (lottieValueCallback == null) {
                this.colorFilterAnimation = null;
            } else {
                this.colorFilterAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.colorFilterAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorFilterAnimation);
            }
        } else if (object == LottieProperty.GRADIENT_COLOR) {
            if (lottieValueCallback == null) {
                if (this.colorCallbackAnimation != null) {
                    this.layer.removeAnimation(this.colorCallbackAnimation);
                }
                this.colorCallbackAnimation = null;
            } else {
                this.colorCallbackAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.colorCallbackAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorCallbackAnimation);
            }
        }
    }
}

