/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import oz.lottie.custom.okio.Timeout$1;

public class Timeout {
    public static final Timeout NONE = new Timeout$1();
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;

    public Timeout timeout(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout < 0: " + l);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        this.timeoutNanos = timeUnit.toNanos(l);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            throw new IllegalStateException("No deadline");
        }
        return this.deadlineNanoTime;
    }

    public Timeout deadlineNanoTime(long l) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l;
        return this;
    }

    public final Timeout deadline(long l, TimeUnit timeUnit) {
        if (l <= 0L) {
            throw new IllegalArgumentException("duration <= 0: " + l);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        return this.deadlineNanoTime(System.nanoTime() + timeUnit.toNanos(l));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (this.hasDeadline && System.nanoTime() > this.deadlineNanoTime) {
            throw new IOException("deadline reached");
        }
    }
}

