/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.PointF;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.lang.ref.WeakReference;
import oz.lottie.LottieComposition;
import oz.lottie.custom.PathInterpolatorCompat;
import oz.lottie.custom.SparseArrayCompat;
import oz.lottie.parser.JsonUtils;
import oz.lottie.parser.ValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.utils.MiscUtils;
import oz.lottie.utils.Utils;
import oz.lottie.value.Keyframe;

class KeyframeParser {
    private static final float MAX_CP_VALUE = 100.0f;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static SparseArrayCompat pathInterpolatorCache;
    static JsonReader$Options NAMES;

    static {
        NAMES = JsonReader$Options.of("t", "s", "e", "o", "i", "h", "to", "ti");
    }

    KeyframeParser() {
    }

    private static SparseArrayCompat pathInterpolatorCache() {
        if (pathInterpolatorCache == null) {
            pathInterpolatorCache = new SparseArrayCompat();
        }
        return pathInterpolatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WeakReference getInterpolator(int n) {
        Class<KeyframeParser> clazz = KeyframeParser.class;
        synchronized (KeyframeParser.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (WeakReference)KeyframeParser.pathInterpolatorCache().get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInterpolator(int n, WeakReference weakReference) {
        Class<KeyframeParser> clazz = KeyframeParser.class;
        synchronized (KeyframeParser.class) {
            pathInterpolatorCache.put(n, weakReference);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static Keyframe parse(JsonReader jsonReader, LottieComposition lottieComposition, float f2, ValueParser valueParser, boolean bl) {
        if (bl) {
            return KeyframeParser.parseKeyframe(lottieComposition, jsonReader, f2, valueParser);
        }
        return KeyframeParser.parseStaticValue(jsonReader, f2, valueParser);
    }

    private static Keyframe parseKeyframe(LottieComposition lottieComposition, JsonReader jsonReader, float f2, ValueParser valueParser) {
        PointF pointF = null;
        PointF pointF2 = null;
        float f3 = 0.0f;
        Object object = null;
        Object object2 = null;
        boolean bl = false;
        Interpolator interpolator = null;
        PointF pointF3 = null;
        PointF pointF4 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    f3 = (float)jsonReader.nextDouble();
                    break;
                }
                case 1: {
                    object = valueParser.parse(jsonReader, f2);
                    break;
                }
                case 2: {
                    object2 = valueParser.parse(jsonReader, f2);
                    break;
                }
                case 3: {
                    pointF = JsonUtils.jsonToPoint(jsonReader, f2);
                    break;
                }
                case 4: {
                    pointF2 = JsonUtils.jsonToPoint(jsonReader, f2);
                    break;
                }
                case 5: {
                    bl = jsonReader.nextInt() == 1;
                    break;
                }
                case 6: {
                    pointF3 = JsonUtils.jsonToPoint(jsonReader, f2);
                    break;
                }
                case 7: {
                    pointF4 = JsonUtils.jsonToPoint(jsonReader, f2);
                    break;
                }
                default: {
                    jsonReader.skipValue();
                }
            }
        }
        jsonReader.endObject();
        if (bl) {
            object2 = object;
            interpolator = LINEAR_INTERPOLATOR;
        } else if (pointF != null && pointF2 != null) {
            pointF.x = MiscUtils.clamp(pointF.x, -f2, f2);
            pointF.y = MiscUtils.clamp(pointF.y, -100.0f, 100.0f);
            pointF2.x = MiscUtils.clamp(pointF2.x, -f2, f2);
            pointF2.y = MiscUtils.clamp(pointF2.y, -100.0f, 100.0f);
            int n = Utils.hashFor(pointF.x, pointF.y, pointF2.x, pointF2.y);
            WeakReference weakReference = KeyframeParser.getInterpolator(n);
            if (weakReference != null) {
                interpolator = (Interpolator)weakReference.get();
            }
            if (weakReference == null || interpolator == null) {
                interpolator = PathInterpolatorCompat.create(pointF.x / f2, pointF.y / f2, pointF2.x / f2, pointF2.y / f2);
                try {
                    KeyframeParser.putInterpolator(n, new WeakReference<Interpolator>(interpolator));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        } else {
            interpolator = LINEAR_INTERPOLATOR;
        }
        Keyframe keyframe = new Keyframe(lottieComposition, object, object2, interpolator, f3, null);
        keyframe.pathCp1 = pointF3;
        keyframe.pathCp2 = pointF4;
        return keyframe;
    }

    private static Keyframe parseStaticValue(JsonReader jsonReader, float f2, ValueParser valueParser) {
        Object object = valueParser.parse(jsonReader, f2);
        return new Keyframe(object);
    }
}

