/*
 * Decompiled with CFR 0.152.
 */
package oz.main;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.view.View;
import java.lang.reflect.Method;
import oz.main.OZPageView;
import oz.main.OZPreviewView$1;

public class OZPreviewView
extends View {
    OZPageView pageView;
    int m_position;
    int m_realPosition;
    boolean m_singleMode;
    boolean m_isPreviewMode = true;
    private boolean requestInvalidate = false;
    Bitmap mbitmap = null;

    public OZPreviewView(Context context, OZPageView oZPageView, int n, int n2, int n3, boolean bl) {
        super(context);
        this.m_singleMode = bl;
        this.m_position = n;
        this.m_realPosition = n2;
        this.pageView = oZPageView;
        oZPageView.setVisibility(0);
        if (!bl) {
            oZPageView.setPreviewPosition(this.m_position, this.m_realPosition);
        }
        oZPageView.setPreviewView(this.m_position, this);
        if (OZPageView.m_isHardwareAccelerated) {
            try {
                Method method = ((Object)((Object)this)).getClass().getMethod("setLayerType", Integer.TYPE, Paint.class);
                method.invoke((Object)this, 1, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public OZPageView getPageView() {
        return this.pageView;
    }

    public void setPreviewMode(boolean bl) {
        this.m_isPreviewMode = bl;
    }

    public int getPosition() {
        return this.m_position;
    }

    public int getRealPosition() {
        return this.m_realPosition;
    }

    public void removePreview() {
        this.pageView.setPreviewView(this.m_position, null);
    }

    private void checkBitmapForSkia(Canvas canvas) {
        if (canvas != null) {
            if (this.mbitmap != null && (this.mbitmap.getWidth() != canvas.getWidth() || this.mbitmap.getHeight() != canvas.getHeight())) {
                this.mbitmap.recycle();
                this.mbitmap = null;
            }
            if (this.mbitmap == null) {
                this.mbitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)(OZPageView.USE_RGB565 ? Bitmap.Config.RGB_565 : Bitmap.Config.ARGB_8888));
            }
        }
    }

    public void onDraw(Canvas canvas) {
        if (this.pageView != null) {
            if (this.m_isPreviewMode && this.m_singleMode) {
                if (OZPageView.getGraphicType() == 0) {
                    this.draw(canvas, this.m_realPosition, this.pageView.getOffSet(true), this.pageView.getOffSet(false), this.pageView.getScrollPositionX(), this.pageView.getScrollPositionY(), this.pageView.getZoomScale());
                } else if (OZPageView.getGraphicType() == 1) {
                    this.checkBitmapForSkia(canvas);
                    this.pageView.nativeOnPreviewMoveDrawSkia(this.mbitmap, this.m_realPosition + 1, this.pageView.getOffSet(true), this.pageView.getOffSet(false), this.pageView.getScrollPositionX(), this.pageView.getScrollPositionY(), this.pageView.getZoomScale(), this.pageView.m_color_red, this.pageView.m_color_green, this.pageView.m_color_blue);
                    canvas.drawBitmap(this.mbitmap, 0.0f, 0.0f, null);
                }
            } else if (OZPageView.getGraphicType() == 0) {
                this.pageView.draw(canvas, this.pageView.getOffSet(true), this.pageView.getOffSet(false), this.pageView.getScrollPositionX(), this.pageView.getScrollPositionY(), this.pageView.getZoomScale(), false);
            } else if (OZPageView.getGraphicType() == 1) {
                Rect rect;
                this.checkBitmapForSkia(canvas);
                Region region = null;
                if (this.pageView.hasCompClip() && (rect = this.pageView.getCompClipFirst()) != null) {
                    region = new Region(rect);
                }
                this.pageView.nativeOnPreviewDrawSkia(this.mbitmap, this.pageView.m_previewRealPosition + 1, this.pageView.getZoomScale(), this.pageView.getScrollPositionX(), this.pageView.getScrollPositionY(), this.pageView.getOffSet(true), this.pageView.getOffSet(false), this.pageView.m_color_red, this.pageView.m_color_green, this.pageView.m_color_blue, region);
                canvas.drawBitmap(this.mbitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private native void native_drawSkia(Bitmap var1, int var2, float var3, float var4, float var5, float var6, float var7);

    private void draw(Canvas canvas, int n, float f2, float f3, float f4, float f5, float f6) {
        canvas.save();
        canvas.drawARGB(255, this.pageView.m_color_red, this.pageView.m_color_green, this.pageView.m_color_blue);
        float f7 = -f4 + f2;
        float f8 = -f5 + f3;
        canvas.save();
        canvas.translate(f7, f8);
        canvas.scale(f6, f6);
        boolean bl = this.pageView.nativeOnDrawPage(canvas, n + 1);
        canvas.restore();
        if (bl) {
            this.pageView.nativeOnDrawInputComponentSinglePage(canvas, n + 1, f6, f4, f5, f2, f3);
            this.pageView.nativeOnDrawCommentLayer(canvas, true, n + 1, f6, f4, f5, f2, f3);
        } else if (!this.requestInvalidate) {
            this.requestInvalidate = true;
            this.postDelayed(new OZPreviewView$1(this), 100L);
        }
        canvas.restore();
    }

    static /* synthetic */ boolean access$002(OZPreviewView oZPreviewView, boolean bl) {
        oZPreviewView.requestInvalidate = bl;
        return oZPreviewView.requestInvalidate;
    }
}

