/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import oz.main.OZStorage;
import oz.util.OZButton;
import oz.util.OZDialogBuilder$wrapView;

public abstract class OZDialogBuilder {
    public static final int OZ_DIALOG_LAYOUT_DEFAULT = 9999;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TOP = 10000;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE = 11000;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_TOP = 11100;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_TOP_LEFT = 11110;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_TOP_MIDDLE = 11120;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_TOP_RIGHT = 11130;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_BOTTOM = 11200;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_BOTTOM_LEFT = 11210;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_BOTTOM_MIDDLE = 11220;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_TITLE_BOTTOM_RIGHT = 11230;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_BOTTOM = 12000;
    public static final int OZ_DIALOG_LAYOUT_CUSTOM_DESCRIPTION = 12010;
    public static final int OZ_DIALOG_VIEW_TITLE_TOP = 11121;
    public static final int OZ_DIALOG_VIEW_TITLE_BOTTOM = 11221;
    public static final int CUSTOM_TITLE_ALL = 255;
    public static final int CUSTOM_TITLE_TOP = 240;
    public static final int CUSTOM_TITLE_TOP_TEXT = 128;
    public static final int CUSTOM_TITLE_TOP_LEFT = 64;
    public static final int CUSTOM_TITLE_TOP_RIGHT = 32;
    public static final int CUSTOM_TITLE_TOP_CENTER = 16;
    public static final int CUSTOM_TITLE_BOTTOM = 15;
    public static final int CUSTOM_TITLE_BOTTOM_TEXT = 8;
    public static final int CUSTOM_TITLE_BOTTOM_LEFT = 4;
    public static final int CUSTOM_TITLE_BOTTOM_RIGHT = 2;
    public static final int CUSTOM_TITLE_BOTTOM_CENTER = 1;
    public static final int CUSTOM_TITLE_NONE = 0;
    private Context mContext;
    private String mTitle;
    private String mDescription;
    private int mTitleAlign;
    private float mTitleSize;
    private int mTitleTextColor;
    private int useCustomTitle;
    private int mMinWidth;
    protected ArrayList mViews;

    public OZDialogBuilder(Context context) {
        this.mContext = context;
        this.mTitleAlign = -1;
        this.mTitleSize = -1.0f;
        this.mTitleTextColor = 0;
        this.useCustomTitle = 255;
        this.mViews = new ArrayList();
        this.mMinWidth = -1;
        this.mDescription = "";
    }

    protected Context getContext() {
        return this.mContext;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setTitleTextAlign(int n) {
        this.mTitleAlign = n;
    }

    public int getDefaultTitleTextAlign() {
        return 17;
    }

    public int getTitleTextAlign() {
        return this.mTitleAlign == -1 ? this.getDefaultTitleTextAlign() : this.mTitleAlign;
    }

    public void setTitleTextSize(float f2) {
        this.mTitleSize = f2;
    }

    public void setTitleTextColor(int n) {
        this.mTitleTextColor = n;
    }

    public int getTitleTextColor() {
        return this.mTitleTextColor;
    }

    public float getDefaultTitleTextSize() {
        return 21.0f;
    }

    public float getTitleTextSize() {
        return this.mTitleSize == -1.0f ? this.getDefaultTitleTextSize() : this.mTitleSize;
    }

    public void setUseCustomTitle(int n) {
        this.useCustomTitle = n;
    }

    public int getUseCustomTitle() {
        return this.useCustomTitle;
    }

    public void addView(View view, int n) {
        this.addView(view, n, 0);
    }

    public void addView(View view, int n, int n2) {
        if (view != null) {
            this.mViews.add(new OZDialogBuilder$wrapView(this, view, n, n2));
        }
    }

    public void addButton(OZButton oZButton, int n, View.OnClickListener onClickListener) {
        this.addButton(oZButton, n, 0, onClickListener);
    }

    public void addButton(OZButton oZButton, int n, int n2) {
        if (oZButton != null) {
            this.addView((View)oZButton, n, n2);
        }
    }

    public void addButton(OZButton oZButton, int n, int n2, View.OnClickListener onClickListener) {
        if (oZButton != null) {
            OZStorage.setOZButtonOnClickListener(oZButton, onClickListener);
            this.addView((View)oZButton, n, n2);
        }
    }

    public void setMinWidth(int n) {
        this.mMinWidth = n > 0 ? n : -1;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    protected abstract ViewGroup getLayout(int var1);

    public abstract View createCustomView();

    protected abstract View getView(int var1);

    public void addViewbutton(LinearLayout linearLayout, OZButton oZButton) {
        linearLayout.addView((View)oZButton);
    }

    protected void CreateAddView(ArrayList arrayList, ViewGroup viewGroup, ArrayList arrayList2, boolean bl) {
        for (OZDialogBuilder$wrapView oZDialogBuilder$wrapView : this.mViews) {
            boolean bl2 = oZDialogBuilder$wrapView.priority < 0;
            if (bl != bl2) continue;
            try {
                ViewGroup viewGroup2 = (ViewGroup)viewGroup.findViewById(oZDialogBuilder$wrapView.layout);
                if (viewGroup2 == null) {
                    if (arrayList2 != null) {
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            if (((ViewGroup)arrayList2.get(j)).getId() != oZDialogBuilder$wrapView.layout) continue;
                            viewGroup2 = (ViewGroup)arrayList2.get(j);
                            break;
                        }
                    }
                    if (viewGroup2 == null) continue;
                }
                switch (oZDialogBuilder$wrapView.layout) {
                    case 11210: 
                    case 11230: {
                        if (viewGroup2.getChildCount() <= 0) break;
                        viewGroup2.addView(new View(this.getContext()), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(OZStorage.padding_5, -1));
                    }
                }
                if (oZDialogBuilder$wrapView.view instanceof OZButton && viewGroup2 instanceof LinearLayout) {
                    this.addViewbutton((LinearLayout)viewGroup2, (OZButton)oZDialogBuilder$wrapView.view);
                    continue;
                }
                viewGroup2.addView(oZDialogBuilder$wrapView.view);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

