/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.multi;

import java.util.Map;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    public ByQuadrantReader(Reader reader) {
        this.delegate = reader;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        int n = binaryBitmap.getWidth();
        int n2 = binaryBitmap.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        BinaryBitmap binaryBitmap2 = binaryBitmap.crop(0, 0, n3, n4);
        try {
            return this.delegate.decode(binaryBitmap2, map);
        }
        catch (NotFoundException notFoundException) {
            BinaryBitmap binaryBitmap3 = binaryBitmap.crop(n3, 0, n3, n4);
            try {
                return this.delegate.decode(binaryBitmap3, map);
            }
            catch (NotFoundException notFoundException2) {
                BinaryBitmap binaryBitmap4 = binaryBitmap.crop(0, n4, n3, n4);
                try {
                    return this.delegate.decode(binaryBitmap4, map);
                }
                catch (NotFoundException notFoundException3) {
                    BinaryBitmap binaryBitmap5 = binaryBitmap.crop(n3, n4, n3, n4);
                    try {
                        return this.delegate.decode(binaryBitmap5, map);
                    }
                    catch (NotFoundException notFoundException4) {
                        int n5 = n3 / 2;
                        int n6 = n4 / 2;
                        BinaryBitmap binaryBitmap6 = binaryBitmap.crop(n5, n6, n3, n4);
                        return this.delegate.decode(binaryBitmap6, map);
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

