/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.UPCEANReader;
import oz.util.barcode.oned.UPCEANWriter;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 67;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        if (string.length() != 8) {
            throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string.length());
        }
        boolean[] blArray = new boolean[67];
        int n2 = 0;
        n2 += EAN8Writer.appendPattern(blArray, n2, UPCEANReader.START_END_PATTERN, true);
        int n3 = 0;
        while (n3 <= 3) {
            n = Integer.parseInt(string.substring(n3, n3 + 1));
            n2 += EAN8Writer.appendPattern(blArray, n2, UPCEANReader.L_PATTERNS[n], false);
            ++n3;
        }
        n2 += EAN8Writer.appendPattern(blArray, n2, UPCEANReader.MIDDLE_PATTERN, false);
        n3 = 4;
        while (n3 <= 7) {
            n = Integer.parseInt(string.substring(n3, n3 + 1));
            n2 += EAN8Writer.appendPattern(blArray, n2, UPCEANReader.L_PATTERNS[n], true);
            ++n3;
        }
        n2 += EAN8Writer.appendPattern(blArray, n2, UPCEANReader.START_END_PATTERN, true);
        return blArray;
    }
}

