/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.EnumMap;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.UPCEANReader;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    Result decodeRow(int n, BitArray bitArray, int[] nArray) {
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n2 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        String string = stringBuilder.toString();
        Map map = UPCEANExtension5Support.parseExtensionString(string);
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n), new ResultPoint(n2, n)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (map != null) {
            result.putAllMetadata(map);
        }
        return result;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) {
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n = bitArray.getSize();
        int n2 = nArray[1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 5 && n2 < n) {
            int n5 = UPCEANReader.decodeDigit(bitArray, nArray2, n2, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n5 % 10));
            int[] nArray3 = nArray2;
            int n6 = nArray2.length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = nArray3[n7];
                n2 += n8;
                ++n7;
            }
            if (n5 >= 10) {
                n3 |= 1 << 4 - n4;
            }
            if (n4 != 4) {
                n2 = bitArray.getNextSet(n2);
                n2 = bitArray.getNextUnset(n2);
            }
            ++n4;
        }
        if (stringBuilder.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        n4 = UPCEANExtension5Support.determineCheckDigit(n3);
        if (UPCEANExtension5Support.extensionChecksum(stringBuilder.toString()) != n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n2;
    }

    private static int extensionChecksum(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        int n3 = n - 2;
        while (n3 >= 0) {
            n2 += charSequence.charAt(n3) - 48;
            n3 -= 2;
        }
        n2 *= 3;
        n3 = n - 1;
        while (n3 >= 0) {
            n2 += charSequence.charAt(n3) - 48;
            n3 -= 2;
        }
        return (n2 *= 3) % 10;
    }

    private static int determineCheckDigit(int n) {
        int n2 = 0;
        while (n2 < 10) {
            if (n == CHECK_DIGIT_ENCODINGS[n2]) {
                return n2;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Map parseExtensionString(String string) {
        if (string.length() != 5) {
            return null;
        }
        String string2 = UPCEANExtension5Support.parseExtension5String(string);
        if (string2 == null) {
            return null;
        }
        EnumMap<ResultMetadataType, String> enumMap = new EnumMap<ResultMetadataType, String>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.SUGGESTED_PRICE, string2);
        return enumMap;
    }

    private static String parseExtension5String(String string) {
        String string2;
        switch (string.charAt(0)) {
            case '0': {
                string2 = "\u00a3";
                break;
            }
            case '5': {
                string2 = "$";
                break;
            }
            case '9': {
                if ("90000".equals(string)) {
                    return null;
                }
                if ("99991".equals(string)) {
                    return "0.00";
                }
                if ("99990".equals(string)) {
                    return "Used";
                }
                string2 = "";
                break;
            }
            default: {
                string2 = "";
            }
        }
        int n = Integer.parseInt(string.substring(1));
        String string3 = String.valueOf(n / 100);
        int n2 = n % 100;
        String string4 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        return String.valueOf(string2) + string3 + '.' + string4;
    }
}

