/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder.ec;

import oz.util.barcode.pdf417.decoder.ec.ModulusGF;

final class ModulusPoly {
    private final ModulusGF field;
    private final int[] coefficients;

    ModulusPoly(ModulusGF modulusGF, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = modulusGF;
        int n = nArray.length;
        if (n > 1 && nArray[0] == 0) {
            int n2 = 1;
            while (n2 < n && nArray[n2] == 0) {
                ++n2;
            }
            if (n2 == n) {
                this.coefficients = new int[1];
            } else {
                this.coefficients = new int[n - n2];
                System.arraycopy(nArray, n2, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n) {
        return this.coefficients[this.coefficients.length - 1 - n];
    }

    int evaluateAt(int n) {
        if (n == 0) {
            return this.getCoefficient(0);
        }
        int n2 = this.coefficients.length;
        if (n == 1) {
            int n3 = 0;
            int[] nArray = this.coefficients;
            int n4 = this.coefficients.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray[n5];
                n3 = this.field.add(n3, n6);
                ++n5;
            }
            return n3;
        }
        int n7 = this.coefficients[0];
        int n8 = 1;
        while (n8 < n2) {
            n7 = this.field.add(this.field.multiply(n, n7), this.coefficients[n8]);
            ++n8;
        }
        return n7;
    }

    ModulusPoly add(ModulusPoly modulusPoly) {
        int[] nArray;
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (this.isZero()) {
            return modulusPoly;
        }
        if (modulusPoly.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = modulusPoly.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n);
        int n2 = n;
        while (n2 < nArray3.length) {
            nArray[n2] = this.field.add(nArray2[n2 - n], nArray3[n2]);
            ++n2;
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly subtract(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (modulusPoly.isZero()) {
            return this;
        }
        return this.add(modulusPoly.negative());
    }

    ModulusPoly multiply(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (this.isZero() || modulusPoly.isZero()) {
            return this.field.getZero();
        }
        int[] nArray = this.coefficients;
        int n = nArray.length;
        int[] nArray2 = modulusPoly.coefficients;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n + n2 - 1];
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            int n5 = 0;
            while (n5 < n2) {
                nArray3[n3 + n5] = this.field.add(nArray3[n3 + n5], this.field.multiply(n4, nArray2[n5]));
                ++n5;
            }
            ++n3;
        }
        return new ModulusPoly(this.field, nArray3);
    }

    ModulusPoly negative() {
        int n = this.coefficients.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.field.subtract(0, this.coefficients[n2]);
            ++n2;
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiply(int n) {
        if (n == 0) {
            return this.field.getZero();
        }
        if (n == 1) {
            return this;
        }
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.field.multiply(this.coefficients[n3], n);
            ++n3;
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiplyByMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.field.getZero();
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3 + n];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = this.field.multiply(this.coefficients[n4], n2);
            ++n4;
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly[] divide(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (modulusPoly.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        ModulusPoly modulusPoly2 = this.field.getZero();
        ModulusPoly modulusPoly3 = this;
        int n = modulusPoly.getCoefficient(modulusPoly.getDegree());
        int n2 = this.field.inverse(n);
        while (modulusPoly3.getDegree() >= modulusPoly.getDegree() && !modulusPoly3.isZero()) {
            int n3 = modulusPoly3.getDegree() - modulusPoly.getDegree();
            int n4 = this.field.multiply(modulusPoly3.getCoefficient(modulusPoly3.getDegree()), n2);
            ModulusPoly modulusPoly4 = modulusPoly.multiplyByMonomial(n3, n4);
            ModulusPoly modulusPoly5 = this.field.buildMonomial(n3, n4);
            modulusPoly2 = modulusPoly2.add(modulusPoly5);
            modulusPoly3 = modulusPoly3.subtract(modulusPoly4);
        }
        return new ModulusPoly[]{modulusPoly2, modulusPoly3};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(8 * this.getDegree());
        int n = this.getDegree();
        while (n >= 0) {
            int n2 = this.getCoefficient(n);
            if (n2 != 0) {
                if (n2 < 0) {
                    stringBuilder.append(" - ");
                    n2 = -n2;
                } else if (stringBuilder.length() > 0) {
                    stringBuilder.append(" + ");
                }
                if (n == 0 || n2 != 1) {
                    stringBuilder.append(n2);
                }
                if (n != 0) {
                    if (n == 1) {
                        stringBuilder.append('x');
                    } else {
                        stringBuilder.append("x^");
                        stringBuilder.append(n);
                    }
                }
            }
            --n;
        }
        return stringBuilder.toString();
    }
}

