/*
 * Decompiled with CFR 0.152.
 */
package oz.util.speech;

import android.content.Context;
import android.speech.RecognitionListener;
import android.speech.tts.UtteranceProgressListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import oz.util.speech.OZLocaleListener;
import oz.util.speech.OZSpeechHandler;
import oz.util.speech.OZSpeechListener;
import oz.util.speech.OZSpeechManager$1;
import oz.util.speech.OZSpeechManager$2;
import oz.util.speech.OZSpeechRequestInfo;
import oz.util.speech.OZSpeechResultInfo;
import oz.viewer.ui.df.DFUtils;

public class OZSpeechManager
implements OZSpeechListener {
    public static final int OZSPEECH_STATUS_NONE = 0;
    public static final int OZSPEECH_STATUS_STT = 1;
    public static final int OZSPEECH_STATUS_TTS = 2;
    private static OZSpeechManager thisInstance;
    private Context mContext;
    private OZSpeechHandler ozSpeechHandler;
    private Queue requestInfos;
    private OZSpeechRequestInfo currentRequestInfo;
    private RecognitionListener mRecognitionListener;
    private UtteranceProgressListener mUtteranceProgressListener;
    private OZLocaleListener mOZLocaleListener;
    private boolean isEnable = true;
    private Locale targetLocale = null;

    public static OZSpeechManager getInstance(Context context) {
        if (thisInstance == null) {
            thisInstance = new OZSpeechManager(context);
        } else if (context != null && OZSpeechManager.thisInstance.mContext != null && OZSpeechManager.thisInstance.mContext != context) {
            thisInstance.setContext(context);
        }
        return thisInstance;
    }

    private void setContext(Context context) {
        this.mContext = context;
        this.ozSpeechHandler.setContext(this.mContext);
    }

    private OZSpeechManager(Context context) {
        this.mContext = context;
        this.ozSpeechHandler = new OZSpeechHandler(this, this.mContext);
        this.requestInfos = new LinkedList();
        this.setRecognitionListener();
        this.setUtteranceProgressListener();
        this.ozSpeechHandler.setListener(this.mRecognitionListener, this.mUtteranceProgressListener);
    }

    public void addRequest(OZSpeechRequestInfo oZSpeechRequestInfo) {
        if (this.requestInfos.isEmpty() && this.getSpeechStatus() == 0) {
            this.requestInfos.offer(oZSpeechRequestInfo);
            this.runSpeech();
        } else if (this.requestInfos.isEmpty() && !this.isEnable) {
            if (this.getSpeechStatus() == 1 && oZSpeechRequestInfo.mode == 1) {
                this.stop(this.currentRequestInfo);
                this.requestInfos.offer(oZSpeechRequestInfo);
                this.runSpeech();
            } else if (this.getSpeechStatus() == 2 && oZSpeechRequestInfo.mode == 1) {
                this.stop(this.currentRequestInfo);
                this.requestInfos.offer(oZSpeechRequestInfo);
                this.runSpeech();
            }
        } else {
            DFUtils.d("33 ######### addRequest logic error #############");
        }
    }

    private void runSpeech() {
        if (this.requestInfos != null && !this.requestInfos.isEmpty() && this.isEnable) {
            this.currentRequestInfo = (OZSpeechRequestInfo)this.requestInfos.poll();
            this.onRequestStart(this.currentRequestInfo);
            switch (this.currentRequestInfo.mode) {
                case 1: {
                    this.ozSpeechHandler.removeMessages(1);
                    this.ozSpeechHandler.sendEmptyMessageDelayed(1, 300L);
                    break;
                }
                case 3: {
                    if (this.currentRequestInfo.text.equals("")) {
                        this.onRequestEnd(this.getResultInfo(this.currentRequestInfo, 4, "Invalid Text"));
                        break;
                    }
                    this.ozSpeechHandler.removeMessages(3);
                    this.ozSpeechHandler.sendMessage(this.ozSpeechHandler.obtainMessage(3, this.currentRequestInfo.text));
                }
            }
        }
    }

    private void setRecognitionListener() {
        this.mRecognitionListener = new OZSpeechManager$1(this);
    }

    private void setUtteranceProgressListener() {
        this.mUtteranceProgressListener = new OZSpeechManager$2(this);
    }

    public void setDFLocaleListener(OZLocaleListener oZLocaleListener) {
        this.mOZLocaleListener = oZLocaleListener;
        this.setTargetLocale();
    }

    public void dispose() {
        this.requestInfos.clear();
        this.isEnable = true;
        this.requestStop();
        this.stopCurrent();
    }

    public void stop(OZSpeechRequestInfo oZSpeechRequestInfo) {
        if (oZSpeechRequestInfo != null) {
            if (oZSpeechRequestInfo == this.currentRequestInfo) {
                this.isEnable = true;
                this.requestStop();
                this.stopCurrent();
            } else {
                for (OZSpeechRequestInfo oZSpeechRequestInfo2 : this.requestInfos) {
                    if (oZSpeechRequestInfo2 != oZSpeechRequestInfo) continue;
                    this.requestInfos.remove(oZSpeechRequestInfo2);
                    break;
                }
            }
        }
    }

    private void requestStop() {
        this.ozSpeechHandler.sendEmptyMessageDelayed(2, 300L);
        this.ozSpeechHandler.sendEmptyMessage(4);
    }

    private void stopCurrent() {
        if (this.currentRequestInfo != null) {
            this.onRequestCancel(this.currentRequestInfo);
            this.currentRequestInfo = null;
        }
    }

    private OZSpeechResultInfo getResultInfo(OZSpeechRequestInfo oZSpeechRequestInfo, int n, String string) {
        OZSpeechResultInfo oZSpeechResultInfo = new OZSpeechResultInfo();
        oZSpeechResultInfo.ozSpeechRequestInfo = oZSpeechRequestInfo;
        oZSpeechResultInfo.mode = n;
        oZSpeechResultInfo.result = string;
        return oZSpeechResultInfo;
    }

    public void onRequestCancel(OZSpeechRequestInfo oZSpeechRequestInfo) {
        this.currentRequestInfo = null;
        if (oZSpeechRequestInfo.listener != null) {
            oZSpeechRequestInfo.listener.onRequestCancel(oZSpeechRequestInfo);
        }
    }

    public void onRequestStart(OZSpeechRequestInfo oZSpeechRequestInfo) {
        this.isEnable = false;
        if (oZSpeechRequestInfo.listener != null) {
            oZSpeechRequestInfo.listener.onRequestStart(oZSpeechRequestInfo);
        }
    }

    public void onRequestEnd(OZSpeechResultInfo oZSpeechResultInfo) {
        this.currentRequestInfo = null;
        this.isEnable = true;
        this.runSpeech();
        if (oZSpeechResultInfo.ozSpeechRequestInfo != null && oZSpeechResultInfo.ozSpeechRequestInfo.listener != null) {
            oZSpeechResultInfo.ozSpeechRequestInfo.listener.onRequestEnd(oZSpeechResultInfo);
        }
    }

    public void onRequestReadyForSpeech(OZSpeechRequestInfo oZSpeechRequestInfo) {
        if (oZSpeechRequestInfo != null && oZSpeechRequestInfo.listener != null) {
            oZSpeechRequestInfo.listener.onRequestReadyForSpeech(oZSpeechRequestInfo);
        }
    }

    public void onRequestPartialResult(OZSpeechResultInfo oZSpeechResultInfo) {
        if (oZSpeechResultInfo.ozSpeechRequestInfo != null && oZSpeechResultInfo.ozSpeechRequestInfo.listener != null) {
            oZSpeechResultInfo.ozSpeechRequestInfo.listener.onRequestPartialResult(oZSpeechResultInfo);
        }
    }

    public void onRequestEndOfSpeech(OZSpeechRequestInfo oZSpeechRequestInfo) {
        if (oZSpeechRequestInfo != null && oZSpeechRequestInfo.listener != null) {
            oZSpeechRequestInfo.listener.onRequestEndOfSpeech(oZSpeechRequestInfo);
        }
    }

    private String getTotalSTTResult(ArrayList arrayList) {
        String string = "";
        if (arrayList != null) {
            if (arrayList.size() > 1) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    string = string + (String)arrayList.get(j) + " ";
                }
            } else {
                string = (String)arrayList.get(0);
            }
        }
        return string;
    }

    public String getSTTLanguage() {
        return this.targetLocale != null ? this.targetLocale.toString() : Locale.getDefault().toString();
    }

    public Locale getTTSLanguage() {
        return this.targetLocale != null ? this.targetLocale : Locale.getDefault();
    }

    public void setTargetLocale() {
        String string;
        this.targetLocale = this.mOZLocaleListener != null ? ((string = this.mOZLocaleListener.getLocale()).contains("kr") || string.contains("KR") ? Locale.KOREA : (string.contains("us") || string.contains("US") ? Locale.US : Locale.getDefault())) : Locale.getDefault();
    }

    public int getSpeechStatus() {
        int n = -1;
        if (this.currentRequestInfo == null) {
            n = 0;
        } else if (this.currentRequestInfo != null && this.currentRequestInfo.mode == 1) {
            n = 1;
        } else if (this.currentRequestInfo != null && this.currentRequestInfo.mode == 3) {
            n = 2;
        }
        return n;
    }

    static /* synthetic */ OZSpeechRequestInfo access$000(OZSpeechManager oZSpeechManager) {
        return oZSpeechManager.currentRequestInfo;
    }

    static /* synthetic */ OZSpeechResultInfo access$100(OZSpeechManager oZSpeechManager, OZSpeechRequestInfo oZSpeechRequestInfo, int n, String string) {
        return oZSpeechManager.getResultInfo(oZSpeechRequestInfo, n, string);
    }

    static /* synthetic */ OZSpeechHandler access$200(OZSpeechManager oZSpeechManager) {
        return oZSpeechManager.ozSpeechHandler;
    }
}

