/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.StateSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.util.drawable.FitBitmapDrawable;
import oz.util.view.animatable.AnimatableFrameLayout;
import oz.util.view.animatable.AnimatableScrollView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.BubbleTextLayout;
import oz.viewer.ui.df.view.DFLayoutHelper$PROGRESSBAR_POSITION;
import oz.viewer.ui.df.view.DFMicBtnView;
import oz.viewer.ui.df.view.DFProgressbar;
import oz.viewer.ui.df.view.DFRootFrameLayout;

public class DFLayoutHelper {
    public static final int COLOR_TITLE_TEXT = -1;
    public static final int COLOR_QUESTION_TEXT = -1;
    public static final int COLOR_QUESTION_DESCRIPTION_TEXT = -1;
    public static final float COLOR_ALPHA_TITLE = 0.6f;
    public static final float COLOR_ALPHA_QUESTION_DESCRIPTION = 0.6f;
    public static final int SP_TITLE = 16;
    public static final int SP_QUESTION_NUMBER = 24;
    public static final int SP_QUESTION_DESCRIPTION = 18;
    private static final int DP_QUESTION_NUMBER_TEXT_RIGHT_PADDING = 5;
    public static final int DP_SCROLL_VIEW_TOP_MARGIN_SHORT = 10;
    public static final int DP_SCROLL_VIEW_TOP_MARGIN_LONG = 60;
    public static final int DP_DISMISS_BTN_SIZE = 30;
    public static final int DP_DISMISS_BTN_TOP_RIGHT_MARGIN = 10;
    public static final int DP_BOTTOM_BTN_SIZE = 50;
    public static final int DP_BOTTOM_ONOFF_BTN_WIDTH = 60;
    public static final int DP_BOTTOM_ONOFF_BTN_LEFT_RIGHT_MARGIN = 10;
    public static final int DP_BOTTOM_BAR_PADDING = 10;
    public static final int DP_TITLE_LEFT_RIGHT_PADDING = 20;
    public static final int DP_TITLE_TOP_BOTTOM_PADDING = 10;
    public static final int DP_CONTENT_BASE_ROOT_LEFT_RIGHT_PADDING = 40;
    public static final int DP_CONTENT_BASE_ROOT_TOP_BOTTOM_PADDING = 10;
    public static final int DP_CONTENT_BASE_TEXTLAYOUT_BOTTOM_PADDING = 20;
    public static final int DP_MIC_LAYOUT_SIZE = 120;
    public static final int DP_MIC_BOTTOM_MARGIN = 0;
    public static final int DP_DRAWABLE_BOTTOM_RAD = 6;
    public static final int DP_DRAWABLE_BTN_PREV_NEXT_RAD = 6;
    public static final int DP_PROGRESS_MIN_WIDTH_SHORT = 125;
    public static final int DP_PROGRESS_MIN_WIDTH_LONG = 250;
    public static final int DP_LAYOUT_INTERVAL = 10;
    public static final int DP_PROGRESS_MARGIN = 20;
    private static String mLocale;
    private static DFLayoutHelper$PROGRESSBAR_POSITION mProgrssBarPosition;
    private static final int DP_BOTTOM_STROKE = 1;
    private static final int COLOR_BOTTOM_BG;
    private static final int COLOR_BOTTOM_STROKE;
    private static final int COLOR_MIC_BG;
    private static final int COLOR_TINT_BTN_PRESSED;
    private static final int DP_PREV_NEXT_BORDER_WIDTH = 1;
    private static final int COLOR_PREV_NEXT_BTN_BG;
    private static final int COLOR_PREV_NEXT_BTN_PRESSED;
    private static final int COLOR_PREV_NEXT_BTN_DISABLED;
    private static final int COLOR_PREV_NEXT_BTN_STROKE;

    public static Dialog createDialog(Context context, int n, int n2, String string, boolean bl, int n3, int n4) {
        mLocale = string;
        mProgrssBarPosition = DFLayoutHelper$PROGRESSBAR_POSITION.TOP;
        if ((n4 == 1 || n4 == 2) && (bl && (n3 == 0 || n3 == 1) || !bl && n3 == 2)) {
            mProgrssBarPosition = DFLayoutHelper$PROGRESSBAR_POSITION.BOTTOM;
        }
        FrameLayout frameLayout = DFLayoutHelper.createRoot(context);
        frameLayout.addView(DFLayoutHelper.createBackgroundView(context), new ViewGroup.LayoutParams(n, n2));
        frameLayout.addView((View)DFLayoutHelper.createContentLayout(context));
        frameLayout.addView(DFLayoutHelper.createContentBottomLayout(context));
        DFLayoutHelper.appendTopBar(context, (ViewGroup)frameLayout);
        DFLayoutHelper.appendBottomBar(context, (ViewGroup)frameLayout);
        DFLayoutHelper.appendDismiss(context, frameLayout);
        FrameLayout frameLayout2 = DFLayoutHelper.createDummyRoot(context);
        frameLayout2.addView((View)frameLayout);
        DFLayoutHelper.updateDFLayout(context, (View)frameLayout, n, n2);
        Dialog dialog = DFLayoutHelper.createEmptyDialog(context);
        dialog.getWindow().getDecorView().setMinimumHeight(n2);
        dialog.setContentView((View)frameLayout2);
        return dialog;
    }

    public static void updateDFLayoutNoReal(View view, int n, int n2) {
        if (view != null && view.getId() != 65536) {
            view = view.findViewById(65536);
        }
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
            View view2 = view.findViewById(8192);
            if (view2.getMeasuredHeight() == 0) {
                view2.measure(0, 0);
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.bottomMargin = view2.getMeasuredHeight();
            view.findViewById(4096).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void updateDFLayout(Context context, View view, int n, int n2) {
        View view2;
        if (view != null && view.getId() != 65536) {
            view = view.findViewById(65536);
        }
        if (view != null && view.getParent() != null && (view2 = view.findViewById(104857)) != null) {
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
            View view3 = view.findViewById(4608);
            if (view3 != null) {
                if (!DFUtils.isMobile(context)) {
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view3.getLayoutParams();
                    layoutParams.topMargin = DFUtils.toDP(view.getContext(), n2 > n + 400 ? 60.0f : 10.0f);
                } else {
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view3.getLayoutParams();
                    layoutParams.topMargin = DFUtils.toDP(view.getContext(), n2 > n + 400 ? 10.0f : 0.0f);
                }
            }
            DFLayoutHelper.updateDFLayoutNoReal(view, n, n2);
        }
    }

    private static View createContentBottomLayout(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(8192);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 80));
        return frameLayout;
    }

    private static void appendDismiss(Context context, FrameLayout frameLayout) {
        Button button = new Button(context);
        button.setId(4353);
        button.setBackground(DFLayoutHelper.createBtnDrawable(context, 9));
        int n = DFUtils.toDP(context, 30.0f);
        ViewGroup viewGroup = (ViewGroup)frameLayout.findViewById(4096);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n, n, 53);
        layoutParams.rightMargin = layoutParams.topMargin = DFUtils.toDP(context, 10.0f);
        viewGroup.addView((View)button, (ViewGroup.LayoutParams)layoutParams);
    }

    private static Dialog createEmptyDialog(Context context) {
        boolean bl = DFUtils.isMobile(context);
        Dialog dialog = new Dialog(context, bl ? 16973834 : 16973937);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
        Window window = dialog.getWindow();
        window.setSoftInputMode(16);
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = 17;
        layoutParams.flags &= 0xFFFFFFFD;
        window.setAttributes(layoutParams);
        return dialog;
    }

    private static FrameLayout createDummyRoot(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(104856);
        frameLayout.setFocusable(true);
        frameLayout.setFocusableInTouchMode(true);
        return frameLayout;
    }

    private static FrameLayout createRoot(Context context) {
        DFRootFrameLayout dFRootFrameLayout = new DFRootFrameLayout(context);
        dFRootFrameLayout.setId(65536);
        dFRootFrameLayout.setFocusable(true);
        dFRootFrameLayout.setFocusableInTouchMode(true);
        return dFRootFrameLayout;
    }

    private static View createBackgroundView(Context context) {
        View view = new View(context);
        view.setId(104857);
        view.setBackground(DFUtils.getImageDrawable(context, 0));
        return view;
    }

    private static ViewGroup createContentLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(4096);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        linearLayout.addView((View)frameLayout);
        return linearLayout;
    }

    public static ViewGroup createContentBaseLayout(Context context) {
        int n = DFUtils.toDP(context, 20.0f);
        int n2 = DFUtils.toDP(context, 40.0f);
        int n3 = DFUtils.toDP(context, 10.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setPadding(n2, n3, n2, n3);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setOrientation(1);
        LinearLayout linearLayout3 = new LinearLayout(context);
        linearLayout3.setOrientation(1);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 0.0f));
        linearLayout.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        LinearLayout linearLayout4 = new LinearLayout(context);
        linearLayout4.setOrientation(1);
        linearLayout4.setGravity(19);
        linearLayout4.setId(4882);
        linearLayout4.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        LinearLayout linearLayout5 = new LinearLayout(context);
        linearLayout5.setOrientation(0);
        linearLayout5.setPadding(0, 0, 0, n);
        linearLayout2.addView((View)linearLayout5);
        linearLayout3.addView((View)linearLayout4);
        TextView textView = new TextView(context);
        textView.setId(4883);
        textView.setTextColor(-1);
        textView.setTextSize(24.0f);
        textView.setPadding(0, 0, DFUtils.toDP(context, 5.0f), 0);
        TextView textView2 = new TextView(context);
        textView2.setId(4880);
        textView2.setTextColor(-1);
        textView2.setTextSize(24.0f);
        TextView textView3 = new TextView(context);
        textView3.setId(4881);
        textView3.setAlpha(0.6f);
        textView3.setTextColor(-1);
        textView3.setTextSize(18.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(0, DFUtils.toDP(context, 10.0f), 0, 0);
        LinearLayout linearLayout6 = new LinearLayout(context);
        linearLayout6.setOrientation(1);
        linearLayout6.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        linearLayout6.addView((View)textView3, (ViewGroup.LayoutParams)layoutParams);
        linearLayout5.addView((View)textView);
        linearLayout5.addView((View)linearLayout6);
        linearLayout5.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 0.0f));
        return linearLayout;
    }

    private static LinearLayout createTopbarLayout(Context context) {
        int n = DFUtils.toDP(context, 20.0f);
        int n2 = DFUtils.toDP(context, 10.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setId(4352);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(19);
        linearLayout.setPadding(n, n2, n, n2);
        return linearLayout;
    }

    private static TextView createTitleTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setId(4354);
        textView.setTextSize(16.0f);
        textView.setAlpha(0.6f);
        textView.setTextColor(-1);
        return textView;
    }

    private static DFMicBtnView createMICBtn(Context context) {
        DFMicBtnView dFMicBtnView = new DFMicBtnView(context);
        dFMicBtnView.setId(5121);
        return dFMicBtnView;
    }

    private static BubbleTextLayout createBubble(Context context) {
        BubbleTextLayout bubbleTextLayout = new BubbleTextLayout(context);
        bubbleTextLayout.setId(5122);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 81);
        bubbleTextLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        bubbleTextLayout.setMaximumSize(2);
        return bubbleTextLayout;
    }

    private static void appendTopBar(Context context, ViewGroup viewGroup) {
        FrameLayout frameLayout = (FrameLayout)viewGroup.findViewById(4096);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        frameLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        LinearLayout linearLayout2 = DFLayoutHelper.createTopbarLayout(context);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 0.0f));
        AnimatableScrollView animatableScrollView = new AnimatableScrollView(context);
        animatableScrollView.setId(4608);
        animatableScrollView.setFillViewport(true);
        linearLayout.addView((View)animatableScrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        if (viewGroup != null && viewGroup instanceof DFRootFrameLayout) {
            ((DFRootFrameLayout)viewGroup).mSV = animatableScrollView;
        }
        AnimatableFrameLayout animatableFrameLayout = animatableScrollView.getContentView();
        animatableFrameLayout.setId(4864);
        ViewGroup viewGroup2 = DFLayoutHelper.createContentBaseLayout(context);
        animatableScrollView.addChildInContentView((View)viewGroup2);
        linearLayout2.addView((View)DFLayoutHelper.createTitleTextView(context));
        frameLayout.addView((View)DFLayoutHelper.createBubble(context));
    }

    private static Drawable createBottomBarDrawable(Context context) {
        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(COLOR_BOTTOM_BG);
        ShapeDrawable shapeDrawable2 = new ShapeDrawable();
        shapeDrawable2.getPaint().setStrokeWidth((float)DFUtils.toDP(context, 1.0f));
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setColor(COLOR_BOTTOM_STROKE);
        return new LayerDrawable(new Drawable[]{shapeDrawable, shapeDrawable2});
    }

    private static Drawable createMicDrawable(Context context) {
        int n = DFUtils.toDP(context, 100.0f);
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{n, n, n, n, n, n, n, n}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(COLOR_MIC_BG);
        return new LayerDrawable(new Drawable[]{shapeDrawable});
    }

    private static BitmapDrawable getBitmapDrawableFromRes(Context context, int n) {
        return (BitmapDrawable)DFUtils.getImageDrawable(context, n);
    }

    private static Drawable createButtonDrawable(Context context, int n, float f2) {
        return DFLayoutHelper.createButtonDrawable(context, DFLayoutHelper.getBitmapDrawableFromRes(context, n), f2);
    }

    private static Drawable createButtonDrawable(Context context, BitmapDrawable bitmapDrawable, float f2) {
        return new FitBitmapDrawable(bitmapDrawable.getBitmap(), f2);
    }

    private static Drawable createBtnDrawable(Context context, int n) {
        BitmapDrawable bitmapDrawable = DFLayoutHelper.getBitmapDrawableFromRes(context, n);
        BitmapDrawable bitmapDrawable2 = new BitmapDrawable(context.getResources(), bitmapDrawable.getBitmap());
        Drawable drawable2 = DFLayoutHelper.createButtonDrawable(context, bitmapDrawable, 0.5f);
        Drawable drawable3 = DFLayoutHelper.createButtonDrawable(context, bitmapDrawable2, 0.5f);
        drawable3.setTint(COLOR_TINT_BTN_PRESSED);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{drawable2});
        LayerDrawable layerDrawable2 = new LayerDrawable(new Drawable[]{drawable3});
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)layerDrawable2);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)layerDrawable);
        return stateListDrawable;
    }

    private static Drawable createBtnDrawable(Context context, int n, int n2) {
        Drawable drawable2 = DFLayoutHelper.createBtnDrawable(context, n);
        Drawable drawable3 = DFLayoutHelper.createBtnDrawable(context, n2);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100A1}, drawable2);
        stateListDrawable.addState(new int[]{-16842913}, drawable3);
        return stateListDrawable;
    }

    private static Drawable createPrevNextBtnDrawable(Context context, boolean bl) {
        int n = bl ? 5 : 7;
        Drawable drawable2 = DFLayoutHelper.createButtonDrawable(context, n, 0.4f);
        int n2 = bl ? DFUtils.toDP(context, 6.0f) : 0;
        int n3 = !bl ? DFUtils.toDP(context, 6.0f) : 0;
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{n2, n2, n3, n3, n3, n3, n2, n2}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        ShapeDrawable shapeDrawable2 = new ShapeDrawable((Shape)roundRectShape);
        ShapeDrawable shapeDrawable3 = new ShapeDrawable((Shape)roundRectShape);
        ShapeDrawable shapeDrawable4 = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(COLOR_PREV_NEXT_BTN_BG);
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setStrokeWidth((float)DFUtils.toDP(context, 1.0f));
        shapeDrawable2.getPaint().setColor(COLOR_PREV_NEXT_BTN_STROKE);
        shapeDrawable3.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable3.getPaint().setColor(COLOR_PREV_NEXT_BTN_PRESSED);
        shapeDrawable4.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable4.getPaint().setColor(COLOR_PREV_NEXT_BTN_DISABLED);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{shapeDrawable, shapeDrawable2, drawable2});
        LayerDrawable layerDrawable2 = new LayerDrawable(new Drawable[]{shapeDrawable3, shapeDrawable2, drawable2});
        LayerDrawable layerDrawable3 = new LayerDrawable(new Drawable[]{shapeDrawable4, shapeDrawable2, drawable2});
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910, 16842919}, (Drawable)layerDrawable);
        stateListDrawable.addState(new int[]{16842910, -16842919}, (Drawable)layerDrawable2);
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)layerDrawable3);
        return stateListDrawable;
    }

    private static void appendBottomBar(Context context, ViewGroup viewGroup) {
        FrameLayout frameLayout = (FrameLayout)viewGroup.findViewById(8192);
        int n = DFUtils.toDP(context, 10.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setPadding(n, n, n, n);
        linearLayout2.setBackground(DFLayoutHelper.createBottomBarDrawable(context));
        linearLayout2.setOrientation(0);
        linearLayout2.setGravity(19);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        Button button = new Button(context);
        button.setId(8448);
        button.setBackground(DFLayoutHelper.createBtnDrawable(context, 1, 2));
        DFProgressbar dFProgressbar = new DFProgressbar(context, mLocale, mProgrssBarPosition);
        dFProgressbar.setId(8451);
        dFProgressbar.setPadding(0, 0, 0, 0);
        Button button2 = new Button(context);
        button2.setId(8452);
        button2.setBackground(DFLayoutHelper.createPrevNextBtnDrawable(context, true));
        Button button3 = new Button(context);
        button3.setId(8453);
        button3.setBackground(DFLayoutHelper.createPrevNextBtnDrawable(context, false));
        int n2 = DFUtils.toDP(context, 50.0f);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(n2, n2);
        linearLayout2.addView((View)button, (ViewGroup.LayoutParams)layoutParams2);
        int n3 = DFUtils.toDP(context, 120.0f);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(n3, -2);
        layoutParams3.gravity = 17;
        layoutParams3.weight = 1.0f;
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(n2, n2);
        layoutParams4.gravity = 17;
        layoutParams4.weight = 1.0f;
        LinearLayout linearLayout3 = new LinearLayout(context);
        linearLayout3.setBackground(DFLayoutHelper.createMicDrawable(context));
        linearLayout3.addView((View)DFLayoutHelper.createMICBtn(context), (ViewGroup.LayoutParams)layoutParams4);
        LinearLayout linearLayout4 = new LinearLayout(context);
        linearLayout4.addView((View)linearLayout3, (ViewGroup.LayoutParams)layoutParams3);
        if (mProgrssBarPosition == DFLayoutHelper$PROGRESSBAR_POSITION.TOP) {
            linearLayout2.addView(new View(context), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 1, 1.0f));
            linearLayout2.addView((View)button2, (ViewGroup.LayoutParams)layoutParams2);
            linearLayout2.addView((View)button3, (ViewGroup.LayoutParams)layoutParams2);
            FrameLayout frameLayout2 = new FrameLayout(context);
            frameLayout2.addView((View)linearLayout2);
            frameLayout2.addView((View)linearLayout4, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            LinearLayout.LayoutParams layoutParams5 = new LinearLayout.LayoutParams(-1, -2);
            layoutParams5.setMargins(0, 0, 0, 0);
            dFProgressbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams5);
            linearLayout.addView((View)dFProgressbar);
            linearLayout.addView((View)frameLayout2);
        } else if (mProgrssBarPosition == DFLayoutHelper$PROGRESSBAR_POSITION.BOTTOM) {
            LinearLayout.LayoutParams layoutParams6 = new LinearLayout.LayoutParams(-2, -2, 3.0f);
            layoutParams6.setMargins(DFUtils.toDP(context, 20.0f), 0, DFUtils.toDP(context, 20.0f), 0);
            dFProgressbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams6);
            linearLayout2.addView((View)dFProgressbar);
            linearLayout2.addView((View)button2, (ViewGroup.LayoutParams)layoutParams2);
            linearLayout2.addView((View)button3, (ViewGroup.LayoutParams)layoutParams2);
            FrameLayout frameLayout3 = new FrameLayout(context);
            frameLayout3.addView((View)linearLayout2);
            frameLayout3.addView((View)linearLayout4, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            linearLayout.addView((View)frameLayout3);
        }
        frameLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    static {
        COLOR_BOTTOM_BG = Color.argb((int)51, (int)255, (int)255, (int)255);
        COLOR_BOTTOM_STROKE = Color.argb((int)51, (int)0, (int)0, (int)0);
        COLOR_MIC_BG = Color.argb((int)153, (int)255, (int)255, (int)255);
        COLOR_TINT_BTN_PRESSED = Color.argb((int)255, (int)136, (int)136, (int)136);
        COLOR_PREV_NEXT_BTN_BG = Color.argb((int)128, (int)255, (int)255, (int)255);
        COLOR_PREV_NEXT_BTN_PRESSED = Color.argb((int)128, (int)208, (int)208, (int)208);
        COLOR_PREV_NEXT_BTN_DISABLED = Color.argb((int)128, (int)148, (int)148, (int)148);
        COLOR_PREV_NEXT_BTN_STROKE = Color.argb((int)51, (int)0, (int)0, (int)0);
    }
}

