/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableCanvasView;
import oz.viewer.ui.edit.AEditableConst$Size;
import oz.viewer.ui.edit.AEditableImageView$1;
import oz.viewer.ui.edit.AEditableImageView$2;
import oz.viewer.ui.edit.AEditableImageView$3;
import oz.viewer.ui.edit.AEditableImageView$4;
import oz.viewer.ui.edit.AEditableLinearLayout;
import oz.viewer.ui.edit.AEditableUtil;

public class AEditableImageView
extends AEditableLinearLayout {
    private final float TOUCH_TOLERANCE = 4.0f;
    private final int TOP_LEFT = 0;
    private final int TOP_CENTER = 1;
    private final int TOP_RIGHT = 2;
    private final int CENTER_LEFT = 3;
    private final int CENTER_RIGHT = 4;
    private final int BOTTOM_LEFT = 5;
    private final int BOTTOM_CENTER = 6;
    private final int BOTTOM_RIGHT = 7;
    private Bitmap m_editableBitmap;
    private FrameLayout m_imageEditor_middle_Layout;
    private RectF m_dst_rect;
    private int m_changeMode = -1;
    private float mX;
    private float mY;
    private RectF mOriTrackerRect;
    private RectF mTrackerRect;
    private RectF mDrawTempRect;
    private Rect mDrawTempRectI;
    private Paint mDrawPaint;
    private PointF m_touchPoint;
    private boolean isMoveMode;
    private PointF[] m_point;
    private AEditableCanvasView m_editableCanvasView;
    private Dialog m_dialog;

    public AEditableImageView(Context context, AEditableCanvasView aEditableCanvasView, Dialog dialog, Bitmap bitmap, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView);
        this.m_editableCanvasView = aEditableCanvasView;
        this.m_dialog = dialog;
        this.m_editableBitmap = bitmap;
        this.m_touchPoint = new PointF();
        this.mOriTrackerRect = new RectF();
        this.mTrackerRect = new RectF();
        this.mDrawTempRect = new RectF();
        this.mDrawTempRectI = new Rect();
        this.m_point = new PointF[8];
        for (int j = 0; j < this.m_point.length; ++j) {
            this.m_point[j] = new PointF();
        }
        this.mDrawPaint = new Paint();
        this.setBackgroundColor(-1);
        this.setOrientation(1);
        this.addViewLayout();
    }

    private void resizeCheckContactTopLeft(RectF rectF, RectF rectF2, float f2, boolean bl) {
        if (rectF.top >= rectF2.top) {
            rectF2.top = rectF.top;
            rectF2.left = rectF2.right - (bl ? rectF2.height() / f2 : rectF2.height() * f2);
        }
        if (rectF.left >= rectF2.left) {
            rectF2.top = rectF2.top + (bl ? (rectF.left - rectF2.left) * f2 : (rectF.left - rectF2.left) / f2);
            rectF2.left = rectF.left;
        }
    }

    private void resizeCheckContactTopRight(RectF rectF, RectF rectF2, float f2, boolean bl) {
        if (rectF.top >= rectF2.top) {
            rectF2.top = rectF.top;
            rectF2.right = rectF2.left + (bl ? rectF2.height() / f2 : rectF2.height() * f2);
        }
        if (rectF.right <= rectF2.right) {
            rectF2.top = rectF2.top + (bl ? (rectF2.right - rectF.right) * f2 : (rectF2.right - rectF.right) / f2);
            rectF2.right = rectF.right;
        }
    }

    private void resizeCheckContactBottomLeft(RectF rectF, RectF rectF2, float f2, boolean bl) {
        if (rectF.bottom <= rectF2.bottom) {
            rectF2.bottom = rectF.bottom;
            rectF2.left = rectF2.right - (bl ? rectF2.height() / f2 : rectF2.height() * f2);
        }
        if (rectF.left >= rectF2.left) {
            rectF2.bottom = rectF2.bottom - (bl ? (rectF.left - rectF2.left) * f2 : (rectF.left - rectF2.left) / f2);
            rectF2.left = rectF.left;
        }
    }

    private void resizeCheckContactBottomRight(RectF rectF, RectF rectF2, float f2, boolean bl) {
        if (rectF.bottom <= rectF2.bottom) {
            rectF2.bottom = rectF.bottom;
            rectF2.right = rectF2.left + (bl ? rectF2.height() / f2 : rectF2.height() * f2);
        }
        if (rectF.right <= rectF2.right) {
            rectF2.bottom = rectF2.bottom - (bl ? (rectF2.right - rectF.right) * f2 : (rectF2.right - rectF.right) / f2);
            rectF2.right = rectF.right;
        }
    }

    private void resizeCheckMinimum(RectF rectF, int n, float f2, boolean bl) {
        if (rectF.width() < (float)AEditableConst$Size.EDITABLE_GAP_100 || rectF.height() < (float)AEditableConst$Size.EDITABLE_GAP_100) {
            switch (n) {
                case 0: {
                    if (bl) {
                        rectF.top = rectF.bottom - (float)AEditableConst$Size.EDITABLE_GAP_100;
                        rectF.left = rectF.right - (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                        break;
                    }
                    rectF.top = rectF.bottom - (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                    rectF.left = rectF.right - (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 1: {
                    rectF.top = rectF.bottom - (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 2: {
                    if (bl) {
                        rectF.top = rectF.bottom - (float)AEditableConst$Size.EDITABLE_GAP_100;
                        rectF.right = rectF.left + (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                        break;
                    }
                    rectF.top = rectF.bottom - (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                    rectF.right = rectF.left + (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 3: {
                    rectF.left = rectF.right - (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 4: {
                    rectF.right = rectF.left + (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 5: {
                    if (bl) {
                        rectF.bottom = rectF.top + (float)AEditableConst$Size.EDITABLE_GAP_100;
                        rectF.left = rectF.right - (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                        break;
                    }
                    rectF.bottom = rectF.top + (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                    rectF.left = rectF.right - (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 6: {
                    rectF.bottom = rectF.top + (float)AEditableConst$Size.EDITABLE_GAP_100;
                    break;
                }
                case 7: {
                    if (bl) {
                        rectF.bottom = rectF.top + (float)AEditableConst$Size.EDITABLE_GAP_100;
                        rectF.right = rectF.left + (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                        break;
                    }
                    rectF.bottom = rectF.top + (float)AEditableConst$Size.EDITABLE_GAP_100 / f2;
                    rectF.right = rectF.left + (float)AEditableConst$Size.EDITABLE_GAP_100;
                }
            }
        }
    }

    public AEditableBaseView getBaseView() {
        if (this.m_editableCanvasView != null) {
            return this.m_editableCanvasView.getBaseView();
        }
        return super.getBaseView();
    }

    private void calcResizeRectPoint(RectF rectF) {
        this.m_point[0].set(rectF.left, rectF.top);
        this.m_point[1].set(rectF.centerX(), rectF.top);
        this.m_point[2].set(rectF.right, rectF.top);
        this.m_point[3].set(rectF.left, rectF.centerY());
        this.m_point[4].set(rectF.right, rectF.centerY());
        this.m_point[5].set(rectF.left, rectF.bottom);
        this.m_point[6].set(rectF.centerX(), rectF.bottom);
        this.m_point[7].set(rectF.right, rectF.bottom);
    }

    private void addViewLayout() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setBackgroundColor(-16777216);
        AEditableUtil.setViewPadding((View)linearLayout, AEditableConst$Size.EDITABLE_GAP_10);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.setTopLayout(linearLayout);
        this.addView((View)linearLayout);
        this.m_imageEditor_middle_Layout = new AEditableImageView$1(this, this.getContext());
        this.m_imageEditor_middle_Layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.m_imageEditor_middle_Layout.setWillNotDraw(false);
        this.addView((View)this.m_imageEditor_middle_Layout);
        this.m_imageEditor_middle_Layout.invalidate();
    }

    private Bitmap applyImageFilter(Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        if (bitmap2 != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(this.m_editableCanvasView.getBaseView().getICImagePickerWnd().IsEditableFormatJPEG() ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length > 0) {
                bitmap2 = this.m_editableCanvasView.getBaseView().getICImagePickerWnd().nativeApplyImageFilter(byArray, (int)this.m_editableCanvasView.getBaseView().getDstRect().width(), (int)this.m_editableCanvasView.getBaseView().getDstRect().height());
            }
            if (bitmap2 == null) {
                bitmap2 = bitmap;
            } else {
                this.m_editableCanvasView.getBaseView().getICImagePickerWnd().nativeImageFilterBitmapClear();
            }
        }
        return bitmap2;
    }

    private void setTopLayout(LinearLayout linearLayout) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)OZAndroidResource.getResource("image.edit.use.original"));
        textView.setTextColor(-1);
        textView.setTextSize(20.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 19));
        textView.setPadding(0, 0, AEditableConst$Size.EDITABLE_GAP_10, 0);
        textView.setOnClickListener((View.OnClickListener)new AEditableImageView$2(this));
        linearLayout.addView((View)textView);
        textView = new TextView(this.getContext());
        textView.setText((CharSequence)OZAndroidResource.getResource("image.edit.crop.image"));
        textView.setTextColor(-1);
        textView.setTextSize(20.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 19));
        AEditableUtil.setViewPadding((View)textView, AEditableConst$Size.EDITABLE_GAP_10, 0);
        textView.setOnClickListener((View.OnClickListener)new AEditableImageView$3(this));
        linearLayout.addView((View)textView);
        textView = new TextView(this.getContext());
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        textView = new TextView(this.getContext());
        textView.setText((CharSequence)OZAndroidResource.getResource(60015));
        textView.setTextColor(-1);
        textView.setTextSize(20.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 21));
        textView.setPadding(AEditableConst$Size.EDITABLE_GAP_10, 0, 0, 0);
        textView.setOnClickListener((View.OnClickListener)new AEditableImageView$4(this));
        linearLayout.addView((View)textView);
    }

    static /* synthetic */ FrameLayout access$000(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_imageEditor_middle_Layout;
    }

    static /* synthetic */ Bitmap access$100(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_editableBitmap;
    }

    static /* synthetic */ RectF access$200(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_dst_rect;
    }

    static /* synthetic */ RectF access$202(AEditableImageView aEditableImageView, RectF rectF) {
        aEditableImageView.m_dst_rect = rectF;
        return aEditableImageView.m_dst_rect;
    }

    static /* synthetic */ RectF access$300(AEditableImageView aEditableImageView) {
        return aEditableImageView.mTrackerRect;
    }

    static /* synthetic */ Paint access$400(AEditableImageView aEditableImageView) {
        return aEditableImageView.mDrawPaint;
    }

    static /* synthetic */ Rect access$500(AEditableImageView aEditableImageView) {
        return aEditableImageView.mDrawTempRectI;
    }

    static /* synthetic */ boolean access$600(AEditableImageView aEditableImageView) {
        return aEditableImageView.isMoveMode;
    }

    static /* synthetic */ int access$700(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_changeMode;
    }

    static /* synthetic */ RectF access$800(AEditableImageView aEditableImageView) {
        return aEditableImageView.mOriTrackerRect;
    }

    static /* synthetic */ float access$900(AEditableImageView aEditableImageView) {
        return aEditableImageView.mX;
    }

    static /* synthetic */ float access$1000(AEditableImageView aEditableImageView) {
        return aEditableImageView.mY;
    }

    static /* synthetic */ void access$1100(AEditableImageView aEditableImageView, RectF rectF, RectF rectF2, float f2, boolean bl) {
        aEditableImageView.resizeCheckContactTopLeft(rectF, rectF2, f2, bl);
    }

    static /* synthetic */ void access$1200(AEditableImageView aEditableImageView, RectF rectF, RectF rectF2, float f2, boolean bl) {
        aEditableImageView.resizeCheckContactTopRight(rectF, rectF2, f2, bl);
    }

    static /* synthetic */ void access$1300(AEditableImageView aEditableImageView, RectF rectF, RectF rectF2, float f2, boolean bl) {
        aEditableImageView.resizeCheckContactBottomLeft(rectF, rectF2, f2, bl);
    }

    static /* synthetic */ void access$1400(AEditableImageView aEditableImageView, RectF rectF, RectF rectF2, float f2, boolean bl) {
        aEditableImageView.resizeCheckContactBottomRight(rectF, rectF2, f2, bl);
    }

    static /* synthetic */ void access$1500(AEditableImageView aEditableImageView, RectF rectF, int n, float f2, boolean bl) {
        aEditableImageView.resizeCheckMinimum(rectF, n, f2, bl);
    }

    static /* synthetic */ RectF access$1600(AEditableImageView aEditableImageView) {
        return aEditableImageView.mDrawTempRect;
    }

    static /* synthetic */ void access$1700(AEditableImageView aEditableImageView, RectF rectF) {
        aEditableImageView.calcResizeRectPoint(rectF);
    }

    static /* synthetic */ PointF[] access$1800(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_point;
    }

    static /* synthetic */ PointF access$1900(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_touchPoint;
    }

    static /* synthetic */ boolean access$602(AEditableImageView aEditableImageView, boolean bl) {
        aEditableImageView.isMoveMode = bl;
        return aEditableImageView.isMoveMode;
    }

    static /* synthetic */ int access$702(AEditableImageView aEditableImageView, int n) {
        aEditableImageView.m_changeMode = n;
        return aEditableImageView.m_changeMode;
    }

    static /* synthetic */ float access$902(AEditableImageView aEditableImageView, float f2) {
        aEditableImageView.mX = f2;
        return aEditableImageView.mX;
    }

    static /* synthetic */ float access$1002(AEditableImageView aEditableImageView, float f2) {
        aEditableImageView.mY = f2;
        return aEditableImageView.mY;
    }

    static /* synthetic */ Bitmap access$2000(AEditableImageView aEditableImageView, Bitmap bitmap) {
        return aEditableImageView.applyImageFilter(bitmap);
    }

    static /* synthetic */ AEditableCanvasView access$2100(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_editableCanvasView;
    }

    static /* synthetic */ Dialog access$2200(AEditableImageView aEditableImageView) {
        return aEditableImageView.m_dialog;
    }
}

