/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oz.main.OZPageView;
import oz.main.OZStorage;
import oz.viewer.ui.main.ACommentView$1;
import oz.viewer.ui.main.ACommentView$2;
import oz.viewer.ui.main.ACommentView$3;
import oz.viewer.ui.main.ACommentView$4;
import oz.viewer.ui.main.ACommentView$5;
import oz.viewer.ui.main.ACommentView$LazyInvoker;
import oz.viewer.ui.main.ACommentView$OZGestureListener;
import oz.viewer.ui.main.ACommentView$OZScaleListener;

public class ACommentView
extends FrameLayout {
    boolean _needsFullRender = true;
    private Picture mBitmap = null;
    private OZPageView pageView = null;
    int m_imageWidth = 0;
    int m_imageHeight = 0;
    boolean isTwoHandScroll = false;
    public boolean _userInteractionEnabled = false;
    boolean m_commentShow = false;
    private GestureDetector mGestureDetector;
    private ScaleGestureDetector mScaleDetector;
    public boolean _isDragMode = false;
    private boolean mUsePenPressure;
    int m_alpha = 255;
    private boolean isEndable = true;
    Paint paint = new Paint(4);
    Path path = new Path();
    Bitmap buffer = null;
    Canvas bufferCanvas = null;
    Animation fadeOut;
    ACommentView$LazyInvoker lazySetNeedsDisplay = null;
    long lazySetNeedsDisplayDuration = 400L;
    private boolean mNeedUpdateBitmap;

    public ACommentView(Context context) {
        super(context);
        Method method;
        this.setBackgroundColor(0);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ACommentView$OZGestureListener(this, null), null, false);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ACommentView$OZScaleListener(this, null));
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                method = ScaleGestureDetector.class.getMethod("setQuickScaleEnabled", Boolean.TYPE);
                if (method != null) {
                    method.invoke((Object)this.mScaleDetector, false);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        try {
            if (Build.VERSION.SDK_INT >= 11) {
                method = ((Object)((Object)this)).getClass().getMethod("setLayerType", Integer.TYPE, Paint.class);
                method.invoke((Object)this, 1, null);
            }
        }
        catch (Exception exception) {
            Log.d((String)"OZViewer", (String)"Not supported layout type.");
        }
        this.setNeedsFullRender();
        this.mUsePenPressure = true;
    }

    public void setViewAlpha(float f2) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setAlpha(f2);
        }
    }

    public void setMemoDragMode(boolean bl) {
        this._isDragMode = bl;
    }

    public void dispose() {
        this.mBitmap = null;
        this.pageView = null;
        this.paint = null;
        this.path = null;
        if (this.buffer != null) {
            this.buffer.recycle();
        }
        this.buffer = null;
        this.bufferCanvas = null;
    }

    public void setAlpha(int n) {
        this.m_alpha = n;
    }

    public void setPageView(OZPageView oZPageView) {
        this.pageView = oZPageView;
    }

    public OZPageView getPageView() {
        return this.pageView;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        if (Build.VERSION.SDK_INT >= 11 && n > 0 && n2 > 0) {
            if (this.m_imageHeight != n2 || this.m_imageWidth != n) {
                if (this.buffer != null) {
                    this.buffer.recycle();
                }
                this.buffer = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.bufferCanvas = new Canvas(this.buffer);
            }
            this.m_imageWidth = n;
            this.m_imageHeight = n2;
            this.setMeasuredDimension(this.m_imageWidth, this.m_imageHeight);
            this.setNeedsFullRender();
        }
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void onGingerbreadSizeChanged(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.m_imageHeight != n2 || this.m_imageWidth != n) {
            if (this.buffer != null) {
                this.buffer.recycle();
            }
            this.buffer = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bufferCanvas = new Canvas(this.buffer);
        }
        this.m_imageWidth = n;
        this.m_imageHeight = n2;
        this.layout(0, 0, n, n2);
        this.setMeasuredDimension(this.m_imageWidth, this.m_imageHeight);
        this.setNeedsFullRender();
    }

    public void setNeedsFullRender() {
        this._needsFullRender = true;
    }

    public void setCommentViewerShow(boolean bl) {
        this.m_commentShow = bl;
        if (this.m_commentShow) {
            this.layout(0, 0, this.m_imageWidth, this.m_imageHeight);
            this.setMeasuredDimension(this.m_imageWidth, this.m_imageHeight);
        }
    }

    public void setUserInteractionEnabled(boolean bl) {
        if (this._userInteractionEnabled != bl) {
            this._userInteractionEnabled = bl;
            if (this._userInteractionEnabled && this.getPageView() != null) {
                this.getPageView().closeVideoPlayingComponent();
                this.getPageView().findComp(new ACommentView$1(this), false);
            }
        }
    }

    public Canvas startBitmapCanvas() {
        this.isEndable = false;
        if (this.mBitmap != null) {
            Canvas canvas = this.mBitmap.beginRecording(this.m_imageWidth, this.m_imageHeight);
            return canvas;
        }
        return null;
    }

    public void endBitmapCanvas(Canvas canvas) {
        if (this.mBitmap != null) {
            this.mBitmap.endRecording();
        }
        this.isEndable = true;
    }

    public native boolean nativeExistSkiaPicture();

    public void fullRender() {
        if (this.m_commentShow) {
            if (OZPageView.getGraphicType() == 0 && this.mBitmap == null) {
                this.mBitmap = new Picture();
                this._needsFullRender = true;
            } else if (OZPageView.getGraphicType() == 1 && !this.nativeExistSkiaPicture()) {
                this._needsFullRender = true;
            }
            if (this._needsFullRender) {
                this.nativeOnFullRender();
                this._needsFullRender = false;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        this.updateBitmapPath();
        if (this.paint != null) {
            this.paint.setAlpha(this.m_alpha);
            canvas.drawBitmap(this.buffer, 0.0f, 0.0f, this.paint);
        }
    }

    public void realDraw(Canvas canvas, float f2, float f3, float f4) {
        if (this.mBitmap != null && this.isEndable) {
            canvas.drawPicture(this.mBitmap, new RectF(f3, f4, f3 + (float)this.mBitmap.getWidth(), f4 + (float)this.mBitmap.getHeight()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animation() {
        ACommentView aCommentView = this;
        synchronized (aCommentView) {
            this.fadeOut = new AlphaAnimation(1.0f, 0.0f);
            this.fadeOut.setDuration(600L);
            this.fadeOut.setStartOffset(0L);
            this.fadeOut.setAnimationListener((Animation.AnimationListener)new ACommentView$2(this));
            this.post(new ACommentView$3(this));
        }
    }

    public native void nativeOnDraw(Canvas var1);

    public native void nativeOnFullRender();

    public native boolean nativeTouchStart(long var1, int var3, float var4, float var5, int var6);

    public native boolean nativeTouchMove(long var1, int var3, float var4, float var5, int var6, int var7);

    public native boolean nativeTouchEnd(long var1, int var3, float var4, float var5, int var6, boolean var7);

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.touchEvent(motionEvent);
    }

    public synchronized void postSetNeedsDisplay() {
        if (this.lazySetNeedsDisplay == null) {
            Handler handler = this.getHandler();
            if (handler != null) {
                this.lazySetNeedsDisplay = new ACommentView$LazyInvoker(this, handler, new ACommentView$4(this));
            }
            this.lazySetNeedsDisplay.post(this.lazySetNeedsDisplayDuration);
        } else {
            this.lazySetNeedsDisplay.post(this.lazySetNeedsDisplayDuration);
        }
    }

    public synchronized void invalidateSetNeedsDisplay() {
        if (this.lazySetNeedsDisplay != null) {
            this.lazySetNeedsDisplay.invalidate();
        }
    }

    public synchronized void postSetNeedsDisplayNow() {
        if (this.lazySetNeedsDisplay != null) {
            this.lazySetNeedsDisplay.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelFadeOutAnimation(boolean bl) {
        ACommentView aCommentView = this;
        synchronized (aCommentView) {
            if (bl) {
                if (this.buffer != null) {
                    this.buffer.eraseColor(0);
                }
                this.invalidate();
            }
            if (this.fadeOut != null) {
                this.fadeOut.cancel();
                this.fadeOut = null;
            }
        }
        this.invalidateSetNeedsDisplay();
    }

    private int getPressureInt(float f2) {
        return Math.max(1, (int)(f2 * 4095.0f));
    }

    private int getPressureMotionEvent(MotionEvent motionEvent) {
        if (this.mUsePenPressure && motionEvent.getToolType(0) == 2) {
            return this.getPressureInt(motionEvent.getPressure());
        }
        return 0;
    }

    public boolean touchEvent(MotionEvent motionEvent) {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.pageView != null && (bl5 = this.pageView.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentMode()) && (bl4 = this.pageView.getMainFrameView().getNativeController().isOnlyDrawWithStylusPen())) {
            bl3 = OZStorage.checkUsingStylusPen(motionEvent);
        }
        boolean bl6 = this.pageView.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentFillMode();
        boolean bl7 = this.pageView.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentMemoMode();
        boolean bl8 = bl2 = bl6 || bl7;
        if (this._isDragMode || bl2) {
            this.setUserInteractionEnabled(false);
        }
        boolean bl9 = !this._userInteractionEnabled || !bl5 || bl5 && bl4 && !bl3;
        boolean bl10 = bl = bl4 && bl3 && !bl6;
        if (bl9 && !bl) {
            if (this.pageView.findShowEdit != null && this.pageView.findShowEdit.mShownKeyboard) {
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                if (f2 >= this.pageView.findShowEdit.m_left + (float)this.pageView.findShowEdit.getPaddingLeft() * this.pageView.findShowEdit.m_scale && f3 >= this.pageView.findShowEdit.m_top + (float)this.pageView.findShowEdit.getPaddingTop() * this.pageView.findShowEdit.m_scale && f2 <= this.pageView.findShowEdit.m_right - (float)this.pageView.findShowEdit.getPaddingRight() * this.pageView.findShowEdit.m_scale && f3 <= this.pageView.findShowEdit.m_bottom - (float)this.pageView.findShowEdit.getPaddingBottom() * this.pageView.findShowEdit.m_scale) {
                    return false;
                }
            }
            return this.pageView.onTouchEvent(motionEvent);
        }
        int n = motionEvent.getPointerCount();
        float f4 = motionEvent.getX();
        float f5 = motionEvent.getY();
        long l = System.currentTimeMillis();
        boolean bl11 = false;
        boolean bl12 = motionEvent.getButtonState() != 0;
        switch (motionEvent.getAction()) {
            case 0: {
                if (bl) {
                    this.pageView.deselectMemoLabel();
                }
                this.cancelFadeOutAnimation(false);
                this.setViewAlpha(1.0f);
                if (!bl6) {
                    bl11 = this.nativeTouchStart(l, n, f4, f5, this.getPressureMotionEvent(motionEvent));
                }
                if (bl11) {
                    this.mNeedUpdateBitmap = true;
                }
                if (bl12) break;
                this.mGestureDetector.onTouchEvent(motionEvent);
                this.mScaleDetector.onTouchEvent(motionEvent);
                break;
            }
            case 2: {
                if (!bl6) {
                    bl11 = this.nativeTouchMove(l, n, f4, f5, this.pageView.getPreviewRealPosition() + 1, this.getPressureMotionEvent(motionEvent));
                }
                if (bl11) {
                    this.mNeedUpdateBitmap = true;
                }
                if (bl12) break;
                this.mGestureDetector.onTouchEvent(motionEvent);
                this.mScaleDetector.onTouchEvent(motionEvent);
                break;
            }
            case 1: 
            case 3: {
                if (!bl6) {
                    bl11 = this.nativeTouchMove(l, n, f4, f5, this.pageView.getPreviewRealPosition() + 1, this.getPressureMotionEvent(motionEvent));
                }
                if (bl11) {
                    this.mNeedUpdateBitmap = true;
                    this.updateBitmapPath();
                }
                if (!bl6) {
                    bl11 = this.nativeTouchEnd(l, n, f4, f5, this.getPressureMotionEvent(motionEvent), motionEvent.getAction() == 3);
                }
                if (this.isTwoHandScroll) {
                    this.pageView.onEndScroll();
                    this.isTwoHandScroll = false;
                    this.invalidate();
                }
                MotionEvent motionEvent2 = motionEvent;
                if (!bl6 && bl11) {
                    motionEvent2 = MotionEvent.obtain((long)motionEvent.getDownTime(), (long)motionEvent.getEventTime(), (int)3, (float)motionEvent.getX(), (float)motionEvent.getY(), (int)motionEvent.getMetaState());
                }
                this.mGestureDetector.onTouchEvent(motionEvent2);
                this.mScaleDetector.onTouchEvent(motionEvent2);
                this.postSetNeedsDisplay();
                break;
            }
        }
        return true;
    }

    private void updateBitmapPath() {
        if (this.mNeedUpdateBitmap) {
            this.nativeOnDraw(this.bufferCanvas);
            this.mNeedUpdateBitmap = false;
        }
    }

    public void bringToFront() {
        if (this.getParent() != null) {
            OZStorage.workUIThread(new ACommentView$5(this));
        }
    }

    public void drawSelectComp(int n, int n2, int n3, int n4, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, boolean bl) {
        Canvas canvas = this.bufferCanvas;
        if (canvas != null) {
            Paint paint = new Paint(1);
            paint.setColor(Color.argb((int)n, (int)n2, (int)n3, (int)n4));
            if (!bl) {
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(f2);
                paint.setStrokeCap(Paint.Cap.ROUND);
                paint.setStrokeJoin(Paint.Join.ROUND);
            } else {
                paint.setStyle(Paint.Style.FILL);
            }
            canvas.save();
            canvas.scale(f3, f3);
            canvas.translate(-f4 / f3, -f5 / f3);
            canvas.translate(f6, f7);
            canvas.drawRect(new RectF(f8, f9, f10, f11), paint);
            canvas.restore();
            this.postSetNeedsDisplay();
        }
    }

    static /* synthetic */ OZPageView access$200(ACommentView aCommentView) {
        return aCommentView.pageView;
    }

    static /* synthetic */ void access$301(ACommentView aCommentView) {
        super.bringToFront();
    }
}

