/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.view.View;
import android.view.ViewGroup;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.OverlayObject;
import oz.viewer.ui.main.overlay.OverlayView$AutoHideAble;

public class OverlayView
extends OverlayObject {
    private boolean mNeedUpdate = false;
    private boolean mEnable;
    private boolean mIsAutoHideEnable;
    private int mHideVisibility;
    private int mDisableVisibility;

    OverlayView(OverlayLayout overlayLayout, int n) {
        super(overlayLayout, n);
        this.setHideVisibility(4);
        this.setDisableVisibility(8);
        this.setEnable(true);
    }

    public void update() {
        this.updateView();
    }

    public void requestNeedUpdateView() {
        this.mNeedUpdate = true;
    }

    public void requestUpdateView() {
        if (this.needUpdateView()) {
            this.updateView();
            this.mNeedUpdate = false;
        }
    }

    protected boolean needUpdateView() {
        return this.mNeedUpdate && this.getView() != null;
    }

    public void setEnable(boolean bl) {
        if (this.mEnable != bl) {
            this.mEnable = bl;
            if (!this.mEnable) {
                OverlayView$AutoHideAble overlayView$AutoHideAble;
                if (this.isAutoHideEnable() && this instanceof OverlayView$AutoHideAble && (overlayView$AutoHideAble = (OverlayView$AutoHideAble)((Object)this)).isAutoHiding()) {
                    overlayView$AutoHideAble.autoHideCancel();
                }
                this.hide();
            }
            if (this.mDisableVisibility != -1 && this.getView() != null && this.getView().getVisibility() != this.mDisableVisibility) {
                this.getView().setVisibility(this.mDisableVisibility);
            }
        }
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setAutoHideEnable(boolean bl) {
        this.mIsAutoHideEnable = bl;
    }

    public boolean isAutoHideEnable() {
        return this.mIsAutoHideEnable;
    }

    protected View getView() {
        return null;
    }

    protected void updateView() {
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
    }

    public void show(boolean bl) {
        if (this.isEnable()) {
            this.requestUpdateView();
            if (!this.isShowing()) {
                this.getView().setVisibility(0);
                this.getParent().requestLayout();
            }
            if (bl && this.isAutoHideEnable() && this instanceof OverlayView$AutoHideAble) {
                OverlayView$AutoHideAble overlayView$AutoHideAble = (OverlayView$AutoHideAble)((Object)this);
                if (overlayView$AutoHideAble.isAutoHiding()) {
                    overlayView$AutoHideAble.autoHideCancel();
                }
                overlayView$AutoHideAble.autoHide();
            }
        }
    }

    public void show() {
        this.show(true);
    }

    public void hide() {
        OverlayView$AutoHideAble overlayView$AutoHideAble;
        if (this.isAutoHideEnable() && this instanceof OverlayView$AutoHideAble && (overlayView$AutoHideAble = (OverlayView$AutoHideAble)((Object)this)).isAutoHiding()) {
            overlayView$AutoHideAble.autoHideCancel();
        }
        this.getView().setVisibility(this.isEnable() ? this.mHideVisibility : this.mDisableVisibility);
        this.getParent().requestLayout();
    }

    protected void setHideVisibility(int n) {
        this.mHideVisibility = n;
    }

    protected void setDisableVisibility(int n) {
        this.mDisableVisibility = n;
    }

    public boolean isShowing() {
        return this.getView() != null && this.getView().getParent() != null && this.getView().getVisibility() == 0;
    }

    public void removeFromParent() {
        super.removeFromParent();
        if (this.getView() != null && this.getView().getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)this.getView().getParent();
            viewGroup.removeView(this.getView());
        }
    }
}

