package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONObject;

/**
 * ACMSからのJSONがbooleanのresultという項目を予め持っているクラスです。booleanのresultを持つJSONに対応するクラスを作成するときはこのクラスを継承してください。
 *
 */
public class ResultJSON extends AcmsCommonJSON {
	public static final String JSONPropertyResult = "result";
	public String result;
	
	public ResultJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		super.parse(json);
		result = getString(json, JSONPropertyResult, null);
	}
}
