package jp.agentec.abook.abv.bl.acms.client.json.content;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.dto.OperationTaskDto;

/**
 * Created by seo-y on 2018/11/19.
 */

public class TaskHotspotJSON extends AbstractJSON {
    public static final String HOTSPOT = "hotspot";
    public static final String PAGE_NUM = "sceneId";
    public static final String SEQ_ID = "seqId";
    public static final String TASK_KEY = "taskKey";
    public static final String TASK_CODE = "taskCode";
    public static final String VIEW_X = "x";
    public static final String VIEW_Y = "y";

    private List<OperationTaskDto> listTaskHotspot;

    public TaskHotspotJSON(String json) {
        super(json);

        JSONArray pageInfo = root.getJSONArray(HOTSPOT);
        OperationTaskDto taskHotspot;
        listTaskHotspot = new ArrayList<OperationTaskDto>();

        for (int i = 0; i < pageInfo.length(); i++) {
            try {
                JSONObject obj = pageInfo.getJSONObject(i);
                taskHotspot = new OperationTaskDto();
                taskHotspot.pageNum = obj.getInt(PAGE_NUM);
                taskHotspot.seqId = obj.getInt(SEQ_ID);
                taskHotspot.taskKey = obj.getString(TASK_KEY);
                taskHotspot.taskCode = obj.getString(TASK_CODE);
                taskHotspot.pdfX = (float) obj.getDouble(VIEW_X);
                taskHotspot.pdfY = (float) obj.getDouble(VIEW_Y);
                listTaskHotspot.add(taskHotspot);
            } catch(Exception ex) {
            }
        }
    }

    public List<OperationTaskDto> getPageTasks(int pageNumber) {
        List<OperationTaskDto> pageTaskHotspot = new ArrayList<OperationTaskDto>();
        pageNumber++;

        for (OperationTaskDto task: listTaskHotspot) {
            if (task.pageNum == pageNumber) {
                pageTaskHotspot.add(task);
            }
        }

        return pageTaskHotspot;
    }

    public void setTaskPosition(OperationTaskDto dto) {
        for (OperationTaskDto lDto : listTaskHotspot) {
            if (lDto.taskKey.equals(dto.taskKey)) {
                lDto.pdfX = dto.pdfX;
                lDto.pdfY = dto.pdfY;
                break;
            }
        }
    }
}
