package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link ChangeRoomNameParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author lee-mk
 * @version 1.0.0
 */
public class ChangeRoomNameParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private String newRoomName;
	private Integer roomId;

	/**
	 * {@link ChangeRoomNameParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param newRoomName ルーム名。
	 * @param roomId ルームID。
	 * @since 1.0.0
	 */
	public ChangeRoomNameParameters(String sid, String cmd, String newRoomName, Integer roomId) {
		this.sid = sid;
		this.cmd = cmd;
		this.newRoomName = newRoomName;
		this.roomId = roomId;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * アクションコマンドを返します。
	 * @return APIのアクションコマンドです。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	/**
	 * ルーム名を返します。
	 * @return ルーム名です。
	 * @since 1.0.0
	 */
	public String getNewRoomName() {
		return newRoomName;
	}

	/**
	 * ルームIDを返します。
	 * @return 変更対象のルームIDです。
	 * @since 1.0.0
	 */
	public Integer getRoomId() {
		return roomId;
	}
}
