package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * @author Lee-mk
 * @version 1.0.0
 */
public class FavoriteGroupParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private Integer targetGroupId;


	/**
	 * {@link FavoriteGroupParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @param targetGroupId お気に入りリクエスト対象になるグループID。
	 * @since 1.0.0
	 */
	public FavoriteGroupParameters(String sid, String cmd, Integer targetGroupId) {
		this.sid = sid;
		this.cmd = cmd;
		this.targetGroupId = targetGroupId;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return コマンド。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	/**
	 * 対象グループIDを返します。
	 * @return 対象グループID。
	 * @since 1.0.0
	 */
	public Integer getTargetGroupId() {
		return targetGroupId;
	}
}
