package jp.agentec.abook.abv.bl.acms.client.parameters;

import java.util.Locale;

/**
 * パスワード変更用のパラメータです。
 * @author Taejin Hong
 * @version 1.1.0
 */
public class PasswordChangeParameters extends AcmsParameters {
	private String loginId;
	private String password;
	private String newPassword;
	private String appVersion;
	private int appId;
	
	/**
	 * {@link PasswordChangeParameters} クラスのインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param loginId ユーザのログインIDです。
	 * @param password　既存のパスワードです。
	 * @param newPassword　新しいパスワードです。
	 * @param appVersion アプリケーションの現在バージョンです。
	 * @since 1.0.0
	 */
	public PasswordChangeParameters(String sid, String loginId, String password, String newPassword, String appVersion, int appId) {
		super(sid);
		
		this.loginId = loginId;
		this.password = password;
		this.newPassword = newPassword;
		this.appVersion = appVersion;
		this.appId = appId;
	}

	/**
	 * ユーザのログインIDを返します。
	 * @return ユーザのログインIDです。
	 * @since 1.0.0
	 */
	public String getLoginId() {
		return loginId;
	}

	/**
	 * 既存のパスワードを返します。
	 * @return　既存のパスワードです。
	 * @since 1.0.0
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * 新しいパスワードを返します。
	 * @return　新しいパスワードです。
	 * @since 1.0.0
	 */
	public String getNewPassword() {
		return newPassword;
	}

	/**
	 * アプリケーションの現在バージョンを返します。
	 * @return アプリケーションの現在バージョンです。
	 * @since 1.0.0
	 */
	public String getAppVersion() {
		return appVersion;
	}
	/**
	 * アプリケーションIDを返します。
	 * @return アプリケーションIDです。
	 * @since 1.0.0
	 */
	public int getAppId() {
		return appId;
	}
	
	/**
	 * システムの言語コードを返します。
	 * @since 1.1.0
	 */
	public String getLanguage() {
		return Locale.getDefault().getLanguage();
	}
}
