package jp.agentec.abook.abv.bl.acms.type;

public enum SaveLocationType {
	/**
	 * ダウンロードした内容を読む。
	 * @since 1.0.0
	 */
	In("0"),
	/**
	 * サーバの内容を読む。
	 * @since 1.0.0
	 */
	Out("1");
	private final String saveLocationType;
	
	SaveLocationType(String saveLocationType) {
		this.saveLocationType = saveLocationType;
	}
	
	/**
	 * サーバ、ローカルの番号を返します。
	 * @return　サーバ、ローカル番号です。
	 * @since 1.0.0
	 */
	public String type() {
		return saveLocationType;
	}

	/**
	 * 指定した数字に対応するLocationTypeの値を返します。
	 * @param saveLocationType
	 * @return　指定した数字に対応するLocationTypeの値です。
	 * @since 1.0.0
	 */
	public static SaveLocationType parse(String saveLocationType) {
		SaveLocationType type = In;
		if ("0".equals(saveLocationType)) {
			type = SaveLocationType.In;
		} else if ("1".equals(saveLocationType)) {
			type = SaveLocationType.Out;
		}		
		return type;
	}
}
