package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.EnqueteDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class EnqueteDao extends AbstractDao {
	/**
	 * context アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ EnqueteDao() {
	}

	@Override
	protected EnqueteDto convert(Cursor cursor) {
		EnqueteDto dto = new EnqueteDto();

		int colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("enquete_id");
		if (colnum != -1) {
			dto.enqueteId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("ab_object_id");
		if (colnum != -1) {
			dto.abObjectId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("ab_enquete_id");
		if (colnum != -1) {
			dto.abEnqueteId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("reply_date_str");
		if (colnum != -1) {
			dto.replyDateStr = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("param");
		if (colnum != -1) {
			dto.param = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("reply_flg");
		if (colnum != -1) {
			dto.replyFlg = toBool(cursor.getInt(colnum));
		}

		return dto;
	}

	public List<EnqueteDto> getEnqueteList(long content_id, long ab_object_id) {
		String[] args = new String[] {""+ content_id, ""+ ab_object_id};
		return rawQueryGetDtoList("select * from t_enquete where content_id=? and ab_object_id=?", args, EnqueteDto.class);
	}

	public void insertEnquete(EnqueteDto dto) {
		insert("insert into t_enquete (enquete_id, ab_object_id, ab_enquete_id, content_id, reply_date_str, param, reply_flg) values (?,?,?,?,?,?,?)", new Object[]{getEnqueteMax(), dto.abObjectId, dto.abEnqueteId, dto.contentId, dto.replyDateStr, dto.param, dto.replyFlg});
	}

	public boolean updateEnquete(EnqueteDto dto) {
		long count = update("update t_enquete set ab_object_id=?, ab_enquete_id=?, content_id=?, reply_date_str=?, param=?, reply_flg=? where enquete_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public List<EnqueteDto> getReplyEnquete() {
		return rawQueryGetDtoList("select * from t_enquete where reply_flg!=1", null, EnqueteDto.class);
	}

	public boolean isCheckEnqueteId(long content_id, long abEnqueteId) { 
		String[] args = new String[] {""+ content_id, ""+ abEnqueteId};
//		List<EnqueteDto> list = rawQueryGetDtoList("select * from t_enquete where content_id = ? and ab_enquete_id = ?", args, EnqueteDto.class);
		
		int count = rawQueryGetInt("select COUNT(content_id) AS count from t_enquete where content_id=? AND ab_enquete_id=?", args);
		return count > 0;
	}
	
	public int getEnqueteMax() { 
		return rawQueryGetInt("select MAX(seq) + 1 AS seq from sqlite_sequence where name=?", new String[]{"t_enquete"});
	}

	/**
	 * 指定コンテンツID（カンマ区切り複数指定）のアンケートを削除する
	 * 
	 * @param deletedList
	 */
	public void deleteUnsendEnquete(String deletedList) {
		if (deletedList == null || deletedList.isEmpty()) {
			return;
		}
		update("delete from t_enquete where content_id in ("+ deletedList +")", null);
	}

}