package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;

public class TContentBookmark extends SQLiteTableScript {
	
	public TContentBookmark() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE t_content_bookmark ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , page_num INTEGER NOT NULL ");
		sql.append("      , page_text TEXT ");
		sql.append("      , page_thumbnail_name ");
		sql.append("      , insert_date DATETIME NOT NULL ");
		sql.append("      , update_date DATETIME NOT NULL ");
		sql.append("      , PRIMARY KEY (content_id, page_num) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
