package jp.agentec.abook.abv.bl.dto;

import java.util.Date;

import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;

/**
 * ダウンロードキュー情報を格納します。
 * 
 * TODO: ContentDtoに統合したのでいずれかの段階で削除
 * 
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ContentDownloadQueueDto extends AbstractDto {
	public long contentId;
	public int resourceVersion; // ContentDownloadParamに渡すためだけに使用
	public String status;
	public Date startDate;
	public int downloadProgress;
	public long resourceDownloadedBytes;
	public Date endDate;
	public boolean logSendedFlg;

	public String displayStatus = "N"; // 未使用へ NotNullのためダミー値をセット
	public String messageCode; // 未使用
	public Date queuedDate = new Date(); // 未使用（保存しているが使っていない）  NotNullのためダミー値をセット
	public double downloadAvgBps; // 未使用（保存しているが使っていない）
	public String resourceDownloadedFilePath; // 未使用（保存しているが使っていない）
	public Date resourceDownloadEndDate; // 未使用（保存しているが使っていない）
	public Date resourceExtractEndDate; // 未使用（保存しているが使っていない）
	public String resourcePath; // 未使用へ
	
	// ダウンロードが止まってしまう問題への応急処置。
	private transient int prevDownloadProgress;
	public transient int noChangeCount;
	
	@Override
	public Object[] getInsertValues() {
		return new Object[]{contentId, resourceVersion, status, displayStatus, messageCode, queuedDate, startDate, downloadAvgBps, downloadProgress, resourceDownloadedBytes, resourceDownloadedFilePath, resourceDownloadEndDate, resourceExtractEndDate, endDate, logSendedFlg};
	}

	@Override
	public Object[] getUpdateValues() {
		return new Object[]{resourceVersion, status, displayStatus, messageCode, queuedDate, startDate, downloadAvgBps, downloadProgress, resourceDownloadedBytes, resourceDownloadedFilePath, resourceDownloadEndDate, resourceExtractEndDate, endDate, logSendedFlg, contentId};
	}

	public ContentDownloadQueueDto() {
		this.status = DownloadStatusType.Waiting.type();
	}
	
	@Override
	public String[] getKeyValues() {
		return new String[]{""+ contentId};
	}
	
	public void checkChange() {
		if (status.equals(DownloadStatusType.Downloading.type())) { // DL中で変化がない場合にカウント
			if (prevDownloadProgress == downloadProgress) {
				noChangeCount++;
			}
			else {
				noChangeCount = 0;
			}
			prevDownloadProgress = downloadProgress;
		}
		else {
			noChangeCount = 0;
		}
	}

}
